/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.print;

import au.com.ordermate.reports.PrintData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import ordermate.database.config.report.ReportGroup;
import ordermate.database.config.report.ReportProperty;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.print.ComponentPrintData;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesComponentTax;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesItemSummary;
import ordermate.database.sales.SalesItemSummaryCreator;
import ordermate.database.sales.SalesLineItem;
import org.apache.commons.lang.StringUtils;

public class ItemPrintData
implements PrintData,
Serializable {
    private static final String SHORT_ITEM_LABEL = "Display Short Item Label";
    private double quantity;
    private String description;
    private double pricePerItem;
    private double price;
    private String priceLevel;
    private String course;
    private String status;
    private boolean openPrice;
    private String discount;
    private String surcharge;
    private String seatNumbers;
    private int holdTime;
    private String notes;
    private String combo;
    private List<ComponentPrintData> components;
    private boolean hasTax;
    private String category;

    public double getQuantity() {
        return this.quantity;
    }

    public String getDescription() {
        return this.description;
    }

    public double getPricePerItem() {
        return this.pricePerItem;
    }

    public double getPrice() {
        return this.price;
    }

    public String getPriceLevel() {
        return this.priceLevel;
    }

    public String getCourse() {
        return this.course;
    }

    public String getStatus() {
        return this.status;
    }

    public boolean isOpenPrice() {
        return this.openPrice;
    }

    public String getDiscount() {
        return this.discount;
    }

    public String getSurcharge() {
        return this.surcharge;
    }

    public String getSeatNumbers() {
        return this.seatNumbers;
    }

    public int getHoldTime() {
        return this.holdTime;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getCombo() {
        return this.combo;
    }

    public boolean getHasTax() {
        return this.hasTax;
    }

    public String getCategory() {
        return this.category;
    }

    public ComponentPrintData[] getComponents() {
        return this.components.toArray(new ComponentPrintData[this.components.size()]);
    }

    public static List<ItemPrintData> getItemPrintData(List<? extends SalesLineItem> items) {
        return ItemPrintData.getItemPrintData(items, true, false, false);
    }

    public static List<ItemPrintData> getItemPrintDataGroupedByCategory(List<? extends SalesLineItem> items) {
        return ItemPrintData.getItemPrintData(items, true, false, true);
    }

    public static List<ItemPrintData> getItemPrintData(List<? extends SalesLineItem> items, boolean printed) {
        return ItemPrintData.getItemPrintData(items, false, printed, false);
    }

    private static List<ItemPrintData> getItemPrintData(List<? extends SalesLineItem> items, boolean justActive, boolean printed, boolean groupedByCategory) {
        SalesItemSummaryCreator creator = SalesItemSummaryCreator.createDefaultInstance();
        if (groupedByCategory) {
            creator.groupByCategory();
        }
        List<SalesItemSummary> summaries = creator.getSummaries(items);
        ArrayList<ItemPrintData> printData = new ArrayList<ItemPrintData>(summaries.size());
        for (SalesItemSummary summary : summaries) {
            if (justActive) {
                printData.add(ItemPrintData.createPrintData(summary));
                continue;
            }
            for (int i = 0; i < SalesItemQuantity.ALL_STATES.length; ++i) {
                String currentState = SalesItemQuantity.ALL_STATES[i];
                if (!summary.getTotalCommittedQuantity(printed, currentState).notEquals(0)) continue;
                printData.add(ItemPrintData.createPrintData(summary, printed, currentState));
            }
        }
        return printData;
    }

    private static ItemPrintData createPrintData(SalesItemSummary summary) {
        ItemPrintData data = ItemPrintData.createPrintDataNoQuantity(summary);
        data.quantity = summary.getTotalQuantity().getValue().doubleValue();
        return data;
    }

    private static ItemPrintData createPrintData(SalesItemSummary summary, boolean printed, String state) {
        ItemPrintData data = ItemPrintData.createPrintDataNoQuantity(summary);
        data.quantity = summary.getTotalCommittedQuantity(printed, state).getValue().doubleValue();
        if (!state.equals("ACTIVE")) {
            data.status = StringUtils.capitalize((String)StringUtils.lowerCase((String)state));
        }
        return data;
    }

    private static ItemPrintData createPrintDataNoQuantity(SalesItemSummary summary) {
        ItemPrintData data = new ItemPrintData();
        SalesItem item = summary.getSalesItem();
        data.price = summary.getTotalPrice().doubleValue();
        data.pricePerItem = item.getItemLevelPricePerItem().doubleValue();
        data.course = Account.getCourses()[item.getCourse()];
        data.holdTime = item.getHoldTime();
        data.notes = item.getNotes();
        data.description = ReportProperty.find(ReportGroup.Invoice, SHORT_ITEM_LABEL).getBooleanValue(Boolean.FALSE).booleanValue() ? (item.getComponentList().size() == 1 ? item.getInventoryItemIfSingle().getLabel() : item.getLabel()) : item.getLongLabel();
        data.openPrice = item.isPriceEdited();
        data.discount = summary.getDiscountsAsString();
        data.surcharge = summary.getSurchargesAsString();
        data.seatNumbers = summary.getSeatNumbersAsString();
        if (item.getParentCombo() != null) {
            data.combo = item.getParentCombo().getLabel();
        }
        Iterator<SalesComponent> compIt = item.getComponentList().iterator();
        HashSet<PriceLevel> existingLevels = new HashSet<PriceLevel>();
        while (compIt.hasNext()) {
            SalesComponent comp = compIt.next();
            PriceLevel level = comp.getPriceLevel();
            if (!level.isShowOnReceipt()) continue;
            if (data.priceLevel != null && !existingLevels.contains(level)) {
                data.priceLevel = data.priceLevel + ", " + level.getLabel();
                existingLevels.add(level);
                continue;
            }
            data.priceLevel = level.getLabel();
            existingLevels.add(level);
        }
        data.components = ComponentPrintData.getComponentPrintData(item.getComponentList());
        for (SalesComponent component : item.getComponentList()) {
            for (SalesComponentTax tax : component.getTaxes()) {
                if (TaxCode.getFreeCode().equals(tax.getTaxCode())) continue;
                data.hasTax = true;
            }
        }
        data.category = summary.getCategory().getLabel();
        return data;
    }

    public static ItemPrintData getDummyItemPrintData() {
        ItemPrintData data = new ItemPrintData();
        data.quantity = 0.0;
        data.description = "No items";
        data.pricePerItem = 0.0;
        data.price = 0.0;
        data.priceLevel = "";
        data.course = "";
        data.status = "";
        data.openPrice = false;
        data.discount = "";
        data.seatNumbers = "";
        data.holdTime = 0;
        data.notes = "";
        data.combo = "";
        data.components = new ArrayList<ComponentPrintData>(0);
        data.category = "";
        return data;
    }
}

