/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.print;

import au.com.ordermate.reports.PrintData;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.sales.ItemGroup;

public class PriceAdjustmentPrintData
implements PrintData {
    private String name;
    private double value;
    private String type;

    public String getName() {
        return this.name;
    }

    public double getValue() {
        return this.value;
    }

    public String getType() {
        return this.type;
    }

    public static List getPriceAdjustmentPrintData(List priceAdjustments, ItemGroup account) {
        ArrayList<PriceAdjustmentPrintData> printData = new ArrayList<PriceAdjustmentPrintData>();
        Price itemTotal = account.getItemHelper().getItemTotal();
        for (SalesPriceAdjustment adjustment : priceAdjustments) {
            PriceAdjustmentPrintData data = new PriceAdjustmentPrintData();
            data.name = adjustment.getLabel();
            if (PriceAdjustmentDirection.DISCOUNT.equals(adjustment.getInventoryPriceAdjustment().getDirection())) {
                data.type = "Discount";
                data.value = adjustment.getValue().doubleValue();
            } else {
                data.type = "Surcharge";
                data.value = adjustment.getValue().doubleValue() * -1.0;
            }
            printData.add(data);
        }
        return printData;
    }
}

