/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.queries.DomainQueries;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;

public class ItemStockIngredientsQueries
implements DomainQueries {
    private static final String INVENTORY_GROUP_NAME = "InventoryGroupName";
    private static final String SALES_NAME = "SalesName";
    private static final String PORTION = "Portion";
    private static final String SIZE = "Size";
    private static final String FK_INVENTORY_GROUP = "FK_inventory_group";

    private static ObjectQuery inventoryItemStockQueryNoOrdering() {
        return Query.select(InventoryGroup.Properties.LABEL, INVENTORY_GROUP_NAME).select(InventoryItem.Properties.LABEL, SALES_NAME).select(InventoryItemSize.Properties.LABEL, SIZE).select(InventoryItemPortion.Properties.LABEL, PORTION).select(StockItem.Properties.LABEL, "StockName").select("0.000000", "CustomStockCost").select(StockInventoryUsageLink.Properties.QUANTITY, "Quantity").select(StockItem.Properties.INGREDIENT_MEASURE_UNIT, "fk_ingredient_measure_unit").select(InventoryGroup.Properties.ID, FK_INVENTORY_GROUP).select(StockInventoryUsageLink.Properties.ID, "FK_stock_item_inventory_unit").linkUsing(InventoryItemUnit.Properties.ITEM).linkUsing(InventoryItem.Properties.MENU_GROUP).joinLeft(StockInventoryUsageLink.class, InventoryItemUnit.Properties.STOCK_ITEM_LINKS).joinLeft(StockItem.class, StockInventoryUsageLink.Properties.STOCK_ITEM).joinLeft(InventoryItemPortion.class, InventoryItemUnit.Properties.PORTION).joinLeft(InventoryItemSize.class, InventoryItemUnit.Properties.SIZE).isNull(InventoryItemUnit.Properties.CUSTOM_STOCK_COST).active(InventoryItemUnit.class);
    }

    public static ObjectQuery inventoryItemStockQuery() {
        return ItemStockIngredientsQueries.orderStockQry(ItemStockIngredientsQueries.inventoryItemStockQueryNoOrdering());
    }

    public static ObjectQuery inventoryItemsWithManualStockCost() {
        return ItemStockIngredientsQueries.orderStockQry(ItemStockIngredientsQueries.inventoryItemsWithManualStockCostNoOrdering());
    }

    private static ObjectQuery orderStockQry(ObjectQuery qry) {
        return qry.orderBy(InventoryGroup.Properties.ID).orderBy(InventoryItem.Properties.LABEL).orderBy(InventoryItemUnit.Properties.SIZE).orderBy(InventoryItemUnit.Properties.PORTION);
    }

    private static ObjectQuery inventoryItemsWithManualStockCostNoOrdering() {
        return Query.select(InventoryGroup.Properties.LABEL, INVENTORY_GROUP_NAME).select(InventoryItem.Properties.LABEL, SALES_NAME).select(InventoryItemSize.Properties.LABEL, SIZE).select(InventoryItemPortion.Properties.LABEL, PORTION).select("Not Specified", "StockName").select(InventoryItemUnit.Properties.CUSTOM_STOCK_COST, "CustomStockCost").select("1", "Quantity").select(MeasureUnitHelper.getMeasureUnit("unit").getID().longValue(), "fk_ingredient_measure_unit").select(InventoryGroup.Properties.ID, FK_INVENTORY_GROUP).selectFunc("null as FK_stock_item_inventory_unit").linkUsing(InventoryItemUnit.Properties.ITEM).linkUsing(InventoryItem.Properties.MENU_GROUP).joinLeft(InventoryItemPortion.class, InventoryItemUnit.Properties.PORTION).joinLeft(InventoryItemSize.class, InventoryItemUnit.Properties.SIZE).active(InventoryItemUnit.class).not().isNull(InventoryItemUnit.Properties.CUSTOM_STOCK_COST);
    }

    public static ObjectQuery allInventoryItemsCost() {
        return ItemStockIngredientsQueries.inventoryItemStockQueryNoOrdering().union(ItemStockIngredientsQueries.inventoryItemsWithManualStockCost());
    }
}

