/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.department;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.List;
import ordermate.database.departments.Department;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.queries.DomainQueries;
import ordermate.database.users.User;

public class DepartmentQueries
implements DomainQueries {
    public static List<Department> getAllDepartments() {
        return DomainQueries.Helper.getAllActive(Department.class);
    }

    public static boolean isSingleDepartment() {
        return DepartmentQueries.getAllDepartments().size() == 1;
    }

    public static Department getFirstDepartment() {
        List<Department> list = DepartmentQueries.getAllDepartments();
        return !list.isEmpty() ? list.get(0) : null;
    }

    public static Department findDepartmentByName(String label) {
        ObjectQuery oQuery = new ObjectQuery();
        return PersistenceManager.getObject(Department.class, oQuery.select(Department.class).active(Department.class).equals(Department.Properties.NAME, label).toString(), null);
    }

    public static Department getUserLastClockedOnDepartment(User userToCheck) {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(FinanceTimesheet.class).equals(FinanceTimesheet.Properties.USER, userToCheck).orderBy(FinanceTimesheet.Properties.TIME_IN, true).limit(1);
        FinanceTimesheet userTimesheet = PersistenceManager.getObject(FinanceTimesheet.class, oQuery.toString(), null);
        return userTimesheet == null ? null : userTimesheet.getDepartment();
    }
}

