/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.finance;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import java.util.Date;
import ordermate.database.finance.Shift;
import ordermate.database.misc.TradingDay;

public class ShiftQueries {
    public static final String POSSIBLE_SHIFTS = "SELECT config_shift.Name FROM config_shift WHERE system_state = 'ACTIVE' ORDER BY sequence";

    public static ObjectQuery getLastShiftForDate(Date date) {
        return Query.select(Shift.class).linkUsing(Shift.Properties.TRADING_DAY).equals(TradingDay.Properties.DATE, date, SQLDateType.DATE).not().isNull(TradingDay.Properties.CLOSE_DATE).orderBy(Shift.Properties.ID, true).limit(1);
    }

    public static ObjectQuery getLastShiftClosedOnOrBefore(Date endDate) {
        return Query.select(Shift.class).linkUsing(Shift.Properties.TRADING_DAY).lessThanOrEqual(TradingDay.Properties.CLOSE_DATE, endDate, SQLDateType.DATE).orderBy(Shift.Properties.ID, true).limit(1);
    }

    public static ObjectQuery getLastShiftClosedInBetween(Date startDate, Date endDate) {
        return Query.select(Shift.class).linkUsing(Shift.Properties.TRADING_DAY).greaterThanOrEqual(TradingDay.Properties.DATE, startDate, SQLDateType.DATE).lessThan(TradingDay.Properties.DATE, endDate, SQLDateType.DATE).not().isNull(TradingDay.Properties.CLOSE_DATE).orderBy(Shift.Properties.ID, true).limit(1);
    }

    public static ObjectQuery getFirstShiftForDate(Date startDate) {
        return Query.select(Shift.class).linkUsing(Shift.Properties.TRADING_DAY).greaterThanOrEqual(TradingDay.Properties.DATE, startDate, SQLDateType.DATE).orderBy(Shift.Properties.ID, false).limit(1);
    }

    public static ObjectQuery getShiftsForDate(Date theDate) {
        return Query.select(Shift.class).equals(TradingDay.Properties.DATE, theDate, SQLDateType.DATE).orderBy(Shift.Properties.ID).linkUsing(Shift.Properties.TRADING_DAY, TradingDay.Properties.ID);
    }

    public static ObjectQuery getCurrentShift() {
        return Query.select(Shift.class).equals(Shift.Properties.TRADING_DAY, TradingDay.getCurrentTradingDay()).orderBy(Shift.Properties.ID, true).limit(1);
    }
}

