/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.finance.debtors;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.finance.debtors.implementation.CustomerDebtor;
import ordermate.database.finance.debtors.implementation.RoomAccount;
import ordermate.database.finance.debtors.implementation.SimpleDebtor;
import ordermate.database.queries.DomainQueries;
import ordermate.database.sales.Customer;

public class DebtorQueries
implements DomainQueries {
    private DebtorQueries() {
    }

    public static List<RoomAccount> getAllRoomAccounts() {
        return DebtorQueries.getAllDebtorsOfType(RoomAccount.class);
    }

    public static final List<AbstractDebtor> getAllDebtors() {
        return PersistenceManager.getObjectList(AbstractDebtor.class, DebtorQueries.getBasicObjectQuery().toString(), new Object[0]);
    }

    public static List<AbstractDebtor> getAllCustomerAccountDebtors() {
        ArrayList<AbstractDebtor> list = new ArrayList<AbstractDebtor>();
        list.addAll(DebtorQueries.getAllDebtorsOfType(CustomerDebtor.class));
        list.addAll(DebtorQueries.getAllDebtorsOfType(SimpleDebtor.class));
        return list;
    }

    public static ObjectQuery getBasicObjectQuery() {
        return Query.select(AbstractDebtor.class).active(AbstractDebtor.class).orderBy(AbstractDebtor.Properties.LABEL);
    }

    public static final <T extends AbstractDebtor> List<T> getAllDebtorsOfType(Class<T> debtorType) {
        return PersistenceManager.getObjectList(debtorType, Query.select(debtorType).active(debtorType).toString(), new Object[0]);
    }

    public static final List<AbstractDebtor> findAccountByName(String name) {
        return PersistenceManager.getObjectList(AbstractDebtor.class, DebtorQueries.getDebtorByLabel(name).toString());
    }

    public static final ObjectQuery getDebtorByLabel(String label) {
        return Query.select(AbstractDebtor.class).active(AbstractDebtor.class).equals(AbstractDebtor.Properties.LABEL, label);
    }

    public static final ObjectQuery getFilteredDebtorQuery(String accountName, Customer customer, List debtorGroups, List<String> paymentStatus, List debtorTypes, Date activeDateFilter, String roomNumber) {
        ObjectQuery query = DebtorQueries.getBasicObjectQuery();
        if (!"".equals(accountName)) {
            query = query.wherePropertyLike(AbstractDebtor.Properties.LABEL, accountName);
        }
        if (customer != null) {
            query = query.equals(CustomerDebtor.Properties.CUSTOMER, customer.getID());
        }
        if (roomNumber != null) {
            query = query.equals(RoomAccount.Properties.ROOM_NUMBER, roomNumber);
        }
        if (debtorGroups != null && debtorGroups.size() > 0) {
            query = query.wherePropertyIn(AbstractDebtor.Properties.GROUP, debtorGroups);
        }
        if (debtorTypes != null && debtorTypes.size() != 0) {
            query = query.whereSubclassIsOneOf(debtorTypes);
        }
        for (String status : paymentStatus) {
            if (status == null || status.equalsIgnoreCase("ALL")) continue;
            if (status.equalsIgnoreCase("ZERO")) {
                query = query.not().equals(AbstractDebtor.Properties.AMOUNT_OUTSTANDING, 0.0);
                continue;
            }
            if (status.equalsIgnoreCase("PAID")) {
                query = query.lessThan(AbstractDebtor.Properties.AMOUNT_OUTSTANDING, 0.005);
                if (activeDateFilter == null) continue;
                query = query.greaterThan(AbstractDebtor.Properties.LAST_ACTIVITY_DATE, activeDateFilter, SQLDateType.DATE);
                continue;
            }
            if (status.equalsIgnoreCase("OUTSTANDING")) {
                query = query.greaterThan(AbstractDebtor.Properties.AMOUNT_OUTSTANDING, 0.005);
                continue;
            }
            if (!status.equalsIgnoreCase("OVERDUE")) continue;
            Date javaDate = new Date();
            query = query.greaterThan(AbstractDebtor.Properties.AMOUNT_OUTSTANDING, 0.005).lessThan(AbstractDebtor.Properties.EARLIEST_DUE_DATE, new java.sql.Date(javaDate.getYear(), javaDate.getMonth(), javaDate.getDate()), SQLDateType.DATE);
        }
        if (activeDateFilter != null) {
            query = query.group().greaterThan(AbstractDebtor.Properties.AMOUNT_OUTSTANDING, 0.005).or().greaterThan(AbstractDebtor.Properties.LAST_ACTIVITY_DATE, activeDateFilter, SQLDateType.DATE).endGroup();
        }
        return query;
    }

    public static final List getFilteredDebtorList(String accountName, Customer customer, List debtorGroups, final String paymentStatus, List debtorTypes, Date activeDateFilter, String roomNumber) {
        ObjectQuery query = DebtorQueries.getFilteredDebtorQuery(accountName, customer, debtorGroups, (List<String>)new ArrayList<String>(){
            {
                this.add(paymentStatus);
            }
        }, debtorTypes, activeDateFilter, roomNumber);
        return PersistenceManager.getObjectList(AbstractDebtor.class, query.toString(), null);
    }

    public static final List<AbstractDebtor> getFilteredDebtorList(String accountName, Customer customer, List debtorGroups, List paymentStatus, List debtorTypes, Date activeDateFilter, String roomNumber) {
        ObjectQuery query = DebtorQueries.getFilteredDebtorQuery(accountName, customer, debtorGroups, paymentStatus, debtorTypes, activeDateFilter, roomNumber);
        return PersistenceManager.getObjectList(AbstractDebtor.class, query.toString(), null);
    }

    public static final ObjectQuery getDebtorGroupWithName(String name) {
        return Query.select(DebtorGroup.class).active(DebtorGroup.class).equals(DebtorGroup.Properties.LABEL, name);
    }
}

