/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.finance.timesheet;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.Calendar;
import java.util.List;
import ordermate.database.finance.timesheet.FinanceTimesheet;
import ordermate.database.users.User;

public class FinanceTimesheetQueries {
    public static List<FinanceTimesheet> getTimesheetsClockedInOrOutWithin(Calendar from, Calendar to) {
        ObjectQuery query = Query.select(FinanceTimesheet.class).wherePropertyBetween(FinanceTimesheet.Properties.TIME_IN, from.getTime(), to.getTime(), SQLDateType.TIMESTAMP).or().wherePropertyBetween(FinanceTimesheet.Properties.TIME_OUT, from.getTime(), to.getTime(), SQLDateType.TIMESTAMP);
        return PersistenceManager.getObjectList(FinanceTimesheet.class, query.toString());
    }

    public static List<FinanceTimesheet> getTimesheetsClockedInOrOutWithinForUser(Calendar from, Calendar to, User user) {
        ObjectQuery query = Query.select(FinanceTimesheet.class).group().wherePropertyBetween(FinanceTimesheet.Properties.TIME_IN, from.getTime(), to.getTime(), SQLDateType.TIMESTAMP).or().wherePropertyBetween(FinanceTimesheet.Properties.TIME_OUT, from.getTime(), to.getTime(), SQLDateType.TIMESTAMP).endGroup().equals(FinanceTimesheet.Properties.USER, user);
        return PersistenceManager.getObjectList(FinanceTimesheet.class, query.toString());
    }
}

