/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.finance.voucher;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.integration.giftvoucher.GiftVoucherConfiguration;
import ordermate.database.integration.giftvoucher.GiftVoucherIntegrationType;
import ordermate.database.queries.DomainQueries;
import ordermate.services.misc.CallMethod;
import ordermate.services.misc.CallMethodOnClassExecutable;

public class VoucherQueries
implements DomainQueries {
    public static final int DEFAULT_RESULTS_LIMIT = 20;
    private static final String VOUCHER_CARD_PREFIX = "06";

    public static final List<GiftVoucherTransaction> getLastActive(int limit, PropertiedObject.Property groupBy, boolean hideZero) {
        ObjectQuery query = Query.select(GiftVoucherTransaction.class).active(GiftVoucherTransaction.class).linkUsing(GiftVoucherTransaction.Properties.GIFT_VOUCHER).active(GiftVoucher.class).orderByDesc(GiftVoucherTransaction.Properties.CREATION_DATE).orderByDesc(GiftVoucherTransaction.Properties.CREATION_TIME);
        if (hideZero) {
            query.not().equals(GiftVoucher.Properties.CACHED_VALUE, 0.0);
        }
        query = limit > 0 ? query.limit(limit) : query.limit(20);
        if (groupBy != null) {
            query = query.groupBy(groupBy);
        }
        return PersistenceManager.getObjectList(GiftVoucherTransaction.class, query.toString());
    }

    public static final List<GiftVoucher> getVouchersForConfigUsedBetweenDates(GiftVoucherConfiguration config, Date startDate, Date endDate) {
        String start = DateTimeUtils.getSQLTimestampFormat().format(startDate);
        String end = DateTimeUtils.getSQLTimestampFormat().format(endDate);
        ObjectQuery query = Query.select(GiftVoucher.class).distinct().active(GiftVoucher.class).linkUsing(GiftVoucher.Properties.ID, GiftVoucherTransaction.Properties.GIFT_VOUCHER);
        VoucherQueries.appendQueryForSchemeVoucherLink(query, config);
        query.whereFunction("TIMESTAMP(" + GiftVoucherTransaction.Properties.CREATION_DATE + ", " + GiftVoucherTransaction.Properties.CREATION_TIME + ") BETWEEN '" + start + "' AND '" + end + "'");
        return VoucherQueries.recalculateCachedValue(PersistenceManager.getObjectList(GiftVoucher.class, query.toString()));
    }

    private static List<GiftVoucher> recalculateCachedValue(List<GiftVoucher> voucherList) {
        if (voucherList.isEmpty()) {
            return voucherList;
        }
        for (GiftVoucher voucher : voucherList) {
            List<GiftVoucherTransaction> voucherTxnList = voucher.getTransactions();
            Price voucherAmount = Price.ZERO_DOLLAR;
            for (GiftVoucherTransaction voucherTxn : voucherTxnList) {
                voucherAmount = voucherAmount.add(voucherTxn.getAmount());
            }
            voucher.setCachedValue(voucherAmount);
        }
        return voucherList;
    }

    public static final List<GiftVoucherConfiguration> getActiveVoucherProviders() {
        return PersistenceManager.getObjectList(GiftVoucherConfiguration.class, Query.select(GiftVoucherConfiguration.class).active(GiftVoucherConfiguration.class).orderBy(GiftVoucherConfiguration.Properties.ID).toString());
    }

    public static final List<GiftVoucherConfiguration> getActiveAutogenVoucherProviders() {
        return PersistenceManager.getObjectList(GiftVoucherConfiguration.class, Query.select(GiftVoucherConfiguration.class).active(GiftVoucherConfiguration.class).equals(GiftVoucherConfiguration.Properties.AUTO_GEN, 1.0).orderBy(GiftVoucherConfiguration.Properties.ID).toString());
    }

    public static final GiftVoucherConfiguration getConfigForVoucher(GiftVoucher voucher) {
        String uuid = voucher.getUniqueId();
        CallMethodOnClassExecutable exec = new CallMethodOnClassExecutable("servermate.services.voucher.ServermateVoucherAdministrator", new CallMethod("getInstance", new Serializable[0]), new CallMethod("getConfigFor", new Serializable[]{uuid}));
        return (GiftVoucherConfiguration)PersistenceManager.getServerConnection().runSync(exec);
    }

    public static GiftVoucher getVoucherForId(String uuid) {
        return PersistenceManager.getObject(GiftVoucher.class, Query.select(GiftVoucher.class).equals(GiftVoucher.Properties.UNIQUE_ID, uuid).toString());
    }

    public static final List<GiftVoucher> getActiveVouchers(GiftVoucherConfiguration config) {
        return PersistenceManager.getObjectList(GiftVoucher.class, VoucherQueries.getActiveVouchersQuery(config).toString());
    }

    public static ObjectQuery getActiveVouchersQuery(GiftVoucherConfiguration config) {
        ObjectQuery query = Query.select(GiftVoucher.class).active(GiftVoucher.class);
        VoucherQueries.appendQueryForSchemeVoucherLink(query, config);
        query.orderBy(GiftVoucher.Properties.ID);
        return query;
    }

    private static void appendQueryForSchemeVoucherLink(ObjectQuery query, GiftVoucherConfiguration config) {
        if (GiftVoucherIntegrationType.POS.equals((Object)config.getIntegrationType())) {
            query.whereFunction(GiftVoucher.Properties.UNIQUE_ID + " LIKE '" + VOUCHER_CARD_PREFIX + config.getPrefix() + "%'");
            query.whereFunction("CHAR_LENGTH(finance_gift_voucher.unique_id) = (CHAR_LENGTH('06" + config.getPrefix() + "') + " + config.getUuidLength() + ")");
        } else if (GiftVoucherIntegrationType.Hive.equals((Object)config.getIntegrationType())) {
            query.whereFunction(GiftVoucher.Properties.UNIQUE_ID + " LIKE '" + config.getPrefix() + "%'");
            query.whereFunction("CHAR_LENGTH(finance_gift_voucher.unique_id) = " + config.getUuidLength());
        }
    }
}

