/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.finance.voucher;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import ordermate.database.finance.Shift;
import ordermate.database.finance.giftvoucher.GiftVoucher;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.DomainQueries;
import ordermate.database.reports.general.PriceReport;
import ordermate.database.searchers.reports.dailysummary.DailySummaryDayOfWeekSplitter;
import ordermate.database.searchers.reports.dailysummary.DailySummaryReportParameters;

public class VoucherTransactionQueries
implements DomainQueries {
    public static ObjectQuery getQueryOfVoucherTopupsSum(Shift shift) {
        ObjectQuery query = VoucherTransactionQueries.getSumOfVoucherTransactions(shift);
        query.greaterThan(GiftVoucherTransaction.Properties.AMOUNT, Price.ZERO_DOLLAR);
        query.isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION);
        return query;
    }

    public static ObjectQuery getQueryOfVoucherTopupReversalsSum(Shift shift) {
        ObjectQuery query = VoucherTransactionQueries.getSumOfVoucherTransactions(shift);
        query.lessThan(GiftVoucherTransaction.Properties.AMOUNT, Price.ZERO_DOLLAR);
        query.not().isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION);
        return query;
    }

    public static ObjectQuery getQueryOfVoucherRedeemReversalsSum(Shift shift) {
        ObjectQuery query = VoucherTransactionQueries.getSumOfVoucherTransactions(shift);
        query.greaterThan(GiftVoucherTransaction.Properties.AMOUNT, Price.ZERO_DOLLAR);
        query.not().isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION);
        return query;
    }

    public static ObjectQuery getReversalForVoucherTxn(GiftVoucherTransaction txn) {
        ObjectQuery query = Query.select(GiftVoucherTransaction.class).active(GiftVoucherTransaction.class);
        query.equals(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION, txn);
        return query;
    }

    public static ObjectQuery getQueryOfVoucherRedeemsSum(Shift shift) {
        ObjectQuery query = VoucherTransactionQueries.getSumOfVoucherTransactions(shift);
        query.lessThan(GiftVoucherTransaction.Properties.AMOUNT, Price.ZERO_DOLLAR);
        query.isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION);
        return query;
    }

    public static ObjectQuery getQueryOfVoucherRedeemsSum(CashDrawer cashDrawer, Shift shift) {
        ObjectQuery query = VoucherTransactionQueries.getQueryOfVoucherSum(cashDrawer, shift);
        query.lessThan(GiftVoucherTransaction.Properties.AMOUNT, Price.ZERO_DOLLAR);
        query.isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION);
        return query;
    }

    public static Object getQueryOfVoucherPurchasesSum(Terminal terminal, Shift shift) {
        ObjectQuery query = VoucherTransactionQueries.getQueryOfVoucherTopupsSum(shift).equals(GiftVoucherTransaction.Properties.TERMINAL, terminal);
        return query;
    }

    public static ObjectQuery getQueryOfVoucherTopupReversalsSum(Terminal terminal, Shift shift) {
        ObjectQuery query = VoucherTransactionQueries.getQueryOfVoucherTopupReversalsSum(shift).equals(GiftVoucherTransaction.Properties.TERMINAL, terminal);
        return query;
    }

    public static ObjectQuery getQueryOfVoucherRedeemReversalsSum(Terminal terminal, Shift shift) {
        ObjectQuery query = VoucherTransactionQueries.getQueryOfVoucherRedeemReversalsSum(shift).equals(GiftVoucherTransaction.Properties.TERMINAL, terminal);
        return query;
    }

    private static ObjectQuery getQueryOfVoucherSum(CashDrawer cashDrawer, Shift shift) {
        ObjectQuery query = Query.select(GiftVoucherTransaction.Properties.ID, "ID").active(GiftVoucherTransaction.class);
        query.linkUsing(GiftVoucherTransaction.Properties.FINANCE_TRANSACTION).sum(GiftVoucherTransaction.Properties.AMOUNT, "price").equals(FinanceTransaction.Properties.CASH_DRAWER, cashDrawer).equals(FinanceTransaction.Properties.SHIFT, shift).not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).groupBy(FinanceTransaction.Properties.SHIFT).groupBy(FinanceTransaction.Properties.CASH_DRAWER);
        return query;
    }

    private static ObjectQuery getSumOfVoucherTransactions(Shift shift) {
        ObjectQuery query = Query.select(GiftVoucherTransaction.Properties.SHIFT, "ID").active(GiftVoucherTransaction.class);
        query.sum(GiftVoucherTransaction.Properties.AMOUNT, "price");
        query.equals(GiftVoucherTransaction.Properties.SHIFT, shift);
        query.not().isNull(GiftVoucherTransaction.Properties.AUTH_ID);
        query.groupBy(GiftVoucherTransaction.Properties.SHIFT);
        return query;
    }

    public static Price getSumOfVoucherRedeems(Shift shift) {
        PriceReport report = PersistenceManager.getObject(PriceReport.class, VoucherTransactionQueries.getQueryOfVoucherRedeemsSum(shift).toString());
        return report != null ? report.getPrice() : Price.ZERO_DOLLAR;
    }

    public static Price getSumOfVoucherTopups(Shift shift) {
        PriceReport report = PersistenceManager.getObject(PriceReport.class, VoucherTransactionQueries.getQueryOfVoucherTopupsSum(shift).toString());
        return report != null ? report.getPrice() : Price.ZERO_DOLLAR;
    }

    public static ObjectQuery getTopupsSumByDaysOfWeek(DailySummaryReportParameters params) {
        ObjectQuery query = Query.select(GiftVoucherTransaction.Properties.ID).select(GiftVoucherTransaction.Properties.CREATION_DATE).selectFunc(new DailySummaryDayOfWeekSplitter(params).generateSQLForDayOfWeekSplitUsingTradingDayID(params.getStart(), params.getEnd())).sum(GiftVoucherTransaction.Properties.AMOUNT, "topups").select(0.0, "redeems").select(0.0, "topup_reversals").select(0.0, "redeem_reversals").active(GiftVoucherTransaction.class).greaterThan(GiftVoucherTransaction.Properties.AMOUNT, Price.ZERO_DOLLAR).not().isNull(GiftVoucherTransaction.Properties.GIFT_VOUCHER).not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).not().isStringEmpty(GiftVoucherTransaction.Properties.AUTH_ID).isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION).linkUsing(TradingDay.Properties.ID, GiftVoucherTransaction.Properties.TRADING_DAY);
        if (params.getSalesLocationsFilter().getSelectedOptions() != null && !params.getSalesLocationsFilter().getSelectedOptions().isEmpty()) {
            query = query.wherePropertyIn(GiftVoucherTransaction.Properties.SALES_LOCATION, params.getSalesLocationsFilter().getSelectedOptions());
        }
        return query.groupBy("day_of_week");
    }

    public static ObjectQuery getRedeemsSumByDaysOfWeek(DailySummaryReportParameters params) {
        ObjectQuery query = Query.select(GiftVoucherTransaction.Properties.ID).select(GiftVoucherTransaction.Properties.CREATION_DATE).selectFunc(new DailySummaryDayOfWeekSplitter(params).generateSQLForDayOfWeekSplitUsingTradingDayID(params.getStart(), params.getEnd())).sum(GiftVoucherTransaction.Properties.AMOUNT, "redeems").select(0.0, "topups").select(0.0, "topup_reversals").select(0.0, "redeem_reversals").active(GiftVoucherTransaction.class).active(FinanceTransaction.class).lessThan(GiftVoucherTransaction.Properties.AMOUNT, Price.ZERO_DOLLAR).not().isNull(GiftVoucherTransaction.Properties.GIFT_VOUCHER).not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).not().isStringEmpty(GiftVoucherTransaction.Properties.AUTH_ID).not().isNull(GiftVoucherTransaction.Properties.FINANCE_TRANSACTION).isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION).linkUsing(TradingDay.Properties.ID, GiftVoucherTransaction.Properties.TRADING_DAY).linkUsing(GiftVoucherTransaction.Properties.FINANCE_TRANSACTION, FinanceTransaction.Properties.ID);
        if (params.getSalesLocationsFilter().getSelectedOptions() != null && params.getSalesLocationsFilter().getSelectedOptions().size() != 0) {
            query = query.wherePropertyIn(GiftVoucherTransaction.Properties.SALES_LOCATION, params.getSalesLocationsFilter().getSelectedOptions());
        }
        return query.groupBy("day_of_week");
    }

    public static ObjectQuery getTopupReversalsSumByDaysOfWeek(DailySummaryReportParameters params) {
        ObjectQuery query = Query.select(GiftVoucherTransaction.Properties.ID).select(GiftVoucherTransaction.Properties.CREATION_DATE).selectFunc(new DailySummaryDayOfWeekSplitter(params).generateSQLForDayOfWeekSplitUsingTradingDayID(params.getStart(), params.getEnd())).sum(GiftVoucherTransaction.Properties.AMOUNT, "topup_reversals").select(0.0, "topups").select(0.0, "redeems").select(0.0, "redeem_reversals").active(GiftVoucherTransaction.class).lessThan(GiftVoucherTransaction.Properties.AMOUNT, Price.ZERO_DOLLAR).not().isNull(GiftVoucherTransaction.Properties.GIFT_VOUCHER).not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).not().isStringEmpty(GiftVoucherTransaction.Properties.AUTH_ID).not().isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION).linkUsing(TradingDay.Properties.ID, GiftVoucherTransaction.Properties.TRADING_DAY);
        if (params.getSalesLocationsFilter().getSelectedOptions() != null && params.getSalesLocationsFilter().getSelectedOptions().size() != 0) {
            query = query.wherePropertyIn(GiftVoucherTransaction.Properties.SALES_LOCATION, params.getSalesLocationsFilter().getSelectedOptions());
        }
        return query.groupBy("day_of_week");
    }

    public static ObjectQuery getRedeemReversalsSumByDaysOfWeek(DailySummaryReportParameters params) {
        ObjectQuery query = Query.select(GiftVoucherTransaction.Properties.ID).select(GiftVoucherTransaction.Properties.CREATION_DATE).selectFunc(new DailySummaryDayOfWeekSplitter(params).generateSQLForDayOfWeekSplitUsingTradingDayID(params.getStart(), params.getEnd())).sum(GiftVoucherTransaction.Properties.AMOUNT, "redeem_reversals").select(0.0, "topups").select(0.0, "redeems").select(0.0, "topup_reversals").active(GiftVoucherTransaction.class).active(FinanceTransaction.class).greaterThan(GiftVoucherTransaction.Properties.AMOUNT, Price.ZERO_DOLLAR).not().isNull(GiftVoucherTransaction.Properties.GIFT_VOUCHER).not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).not().isStringEmpty(GiftVoucherTransaction.Properties.AUTH_ID).not().isNull(GiftVoucherTransaction.Properties.FINANCE_TRANSACTION).not().isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION).linkUsing(TradingDay.Properties.ID, GiftVoucherTransaction.Properties.TRADING_DAY).linkUsing(GiftVoucherTransaction.Properties.FINANCE_TRANSACTION, FinanceTransaction.Properties.ID);
        if (params.getSalesLocationsFilter().getSelectedOptions() != null && params.getSalesLocationsFilter().getSelectedOptions().size() != 0) {
            query = query.wherePropertyIn(GiftVoucherTransaction.Properties.SALES_LOCATION, params.getSalesLocationsFilter().getSelectedOptions());
        }
        return query.groupBy("day_of_week");
    }

    public static ObjectQuery getTopupTxnWithLatestExpiryDate(GiftVoucher voucher) {
        ObjectQuery query = Query.select(GiftVoucherTransaction.class).equals(GiftVoucherTransaction.Properties.GIFT_VOUCHER, voucher).active(GiftVoucherTransaction.class).greaterThan(GiftVoucherTransaction.Properties.ACCOUNT, Price.ZERO_DOLLAR).isNull(GiftVoucherTransaction.Properties.REVERSED_VOUCHER_TRANSACTION).limit(1).orderByDesc(GiftVoucherTransaction.Properties.EXPIRY_DATE).orderByDesc(GiftVoucherTransaction.Properties.EXPIRY_TIME);
        return query;
    }
}

