/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.inventory;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.InventoryAdd;
import ordermate.database.inventory.InventoryAddGroup;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.queries.DomainQueries;

public class InventoryAddQueries
implements DomainQueries {
    public static final ObjectQuery QUERY_GET_BY_NAME_SIZE = Query.select(InventoryAdd.class).equalsParam(InventoryAdd.Properties.LABEL).equalsParam(InventoryAddGroup.Properties.SIZE).linkUsing(InventoryAdd.Properties.ADD_GROUP);

    public static ObjectQuery getAllActiveAdds() {
        return Query.select(InventoryAdd.class).active(InventoryAdd.class).orderBy(InventoryAdd.Properties.LABEL);
    }

    public static InventoryAddGroup getInventoryAddGroupForNameAndSize(String label, InventoryItemSize size, SystemState state) {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(InventoryAddGroup.class).equals(InventoryAddGroup.Properties.LABEL, label).equals(InventoryAddGroup.Properties.SYSTEM_STATE, state).limit(1);
        if (size != null) {
            oQuery.equals(InventoryAddGroup.Properties.SIZE, size);
        }
        return PersistenceManager.getObject(InventoryAddGroup.class, oQuery.toString());
    }

    public static InventoryAdd getInventoryAddForNameAndGroup(String label, InventoryAddGroup addGp, SystemState state) {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(InventoryAdd.class).equals(InventoryAdd.Properties.LABEL, label).equals(InventoryAdd.Properties.SYSTEM_STATE, state);
        if (addGp != null) {
            oQuery.equals(InventoryAdd.Properties.ADD_GROUP, addGp);
        }
        return PersistenceManager.getObject(InventoryAdd.class, oQuery.toString());
    }
}

