/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.inventory;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.OrderBy;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.sql.queries.Operator;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.queries.DomainQueries;

public class InventoryGroupQueries
implements DomainQueries {
    public static final String GET_PROFILE_GROUPS = "SELECT inventory_group.* FROM inventory_group WHERE inventory_group.FK_inventory_profile = ? AND inventory_group.FK_inventory_group IS NULL AND inventory_group.system_state = 'ACTIVE' ORDER BY inventory_group.sequence";
    public static final String GET_GROUP_BY_NAME_PROFILE = "SELECT inventory_group.* FROM inventory_group WHERE inventory_group.system_state = 'ACTIVE' AND inventory_group.name = ? AND inventory_group.FK_inventory_profile = ?";

    public static List<InventoryGroup> getAllGroups() {
        List<InventoryGroup> groups = PersistenceManager.getObjectList(InventoryGroup.class, Query.select(InventoryGroup.class).active(InventoryGroup.class).orderBy(new OrderBy(InventoryGroup.Properties.PARENT_GROUP, Operator.IS_NULL, null, true)).orderBy(InventoryGroup.Properties.LABEL).toString(), new Object[0]);
        ArrayList<InventoryGroup> retList = new ArrayList<InventoryGroup>();
        for (InventoryGroup currentGroup : groups) {
            if (currentGroup.getParentGroup() != null) continue;
            retList.add(currentGroup);
            retList.addAll(currentGroup.getRecursiveSubGroups());
        }
        return retList;
    }

    public static InventoryGroup getInventoryGroupForName(String name) {
        ObjectQuery oQuery = new ObjectQuery().select(InventoryGroup.class).active(InventoryGroup.class).equals(InventoryGroup.Properties.LABEL, name);
        return PersistenceManager.getObject(InventoryGroup.class, oQuery.toString(), null);
    }

    public static InventoryGroup getAnyInventoryGroup() {
        ObjectQuery oQuery = new ObjectQuery().select(InventoryGroup.class).active(InventoryGroup.class);
        return PersistenceManager.getObject(InventoryGroup.class, oQuery.toString(), null);
    }
}

