/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.inventory;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import au.com.ordermate.persistence.list.QueryList;
import java.util.List;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.queries.DomainQueries;

public class InventoryItemQueries
implements DomainQueries {
    public static final String GET_ALL_ACTIVE = "SELECT * FROM inventory_item WHERE system_state = 'ACTIVE' ORDER BY Name";
    private static final LocalCacheListManager<InventoryItem> allInventoryItems = new LocalCacheListManager<InventoryItem>(QueryList.createQueryList(InventoryItem.class, "SELECT * FROM inventory_item WHERE system_state = 'ACTIVE' ORDER BY Name"));
    public static final String QUERY_GET_BY_NAME_PROFILE = "SELECT inventory_item.* FROM inventory_item, inventory_group WHERE inventory_item.name = ? AND inventory_item.FK_inventory_group = inventory_group.ID AND inventory_group.FK_inventory_profile = ? AND inventory_item.system_state = 'ACTIVE' AND inventory_group.system_state = 'ACTIVE' ";
    public static final String QUERY_GET_BY_NAME_GROUP = "SELECT inventory_item.* FROM inventory_item, inventory_group WHERE inventory_item.name = ? AND inventory_item.FK_inventory_group = ? AND inventory_item.FK_inventory_group = inventory_group.ID AND inventory_group.system_state = 'ACTIVE' AND inventory_item.system_state != 'DELETED'";
    public static final String QUERY_GET_BY_NAME_GROUP_SEQUENCE = "SELECT inventory_item.* FROM inventory_item, inventory_group WHERE inventory_item.name = ? AND inventory_item.FK_inventory_group = ? AND inventory_item.sequence = ? AND inventory_item.FK_inventory_group = inventory_group.ID AND inventory_group.system_state = 'ACTIVE' AND inventory_item.system_state != 'DELETED'";

    public static List<InventoryItem> getInventoryItems() {
        return allInventoryItems.getList();
    }

    public static void clearCache() {
        allInventoryItems.clearCache();
    }

    public static InventoryItem getInventoryItemForName(String string) {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(InventoryItem.class).equals(InventoryItem.Properties.LABEL, string).active(InventoryItem.class);
        return PersistenceManager.getObject(InventoryItem.class, oQuery.toString());
    }

    public static InventoryItem getDeletedInventoryItemForName(String string) {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(InventoryItem.class).equals(InventoryItem.Properties.LABEL, string).deleted(InventoryItem.class);
        return PersistenceManager.getObject(InventoryItem.class, oQuery.toString());
    }

    public static List<InventoryItem> getInventoryItemsWithPrice() {
        ObjectQuery allItemWithPricesQuery = Query.select(InventoryItem.class).active(InventoryItem.class).joinLeft(InventoryItemUnit.class, InventoryItemUnit.Properties.ITEM).joinLeft(UnitPriceLevel.class, UnitPriceLevel.Properties.UNIT).not().isNull(UnitPriceLevel.Properties.ID).groupBy(InventoryItem.Properties.ID);
        return PersistenceManager.getObjectList(InventoryItem.class, allItemWithPricesQuery.toString());
    }

    public static List<InventoryItem> getAllActiveInventoryItems() {
        return PersistenceManager.getObjectList(InventoryItem.class, GET_ALL_ACTIVE);
    }
}

