/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.inventory;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.sql.SQL;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.queries.DomainQueries;

public class InventoryItemUnitQueries
implements DomainQueries {
    public static final String QUERY_GET_BY_ID = "SELECT * FROM inventory_item_unit WHERE ID = ?";
    public static final String QUERY_GET_BY_EXT_ID = "SELECT * FROM inventory_item_unit WHERE external_id = ?";
    public static final String QUERY_GET_BY_BARCODE = "SELECT inventory_item_unit.* FROM inventory_item_unit_barcodes INNER JOIN inventory_item_unit_barcodes_link ON inventory_item_unit_barcodes_link.FK_inventory_item_unit_barcodes = inventory_item_unit_barcodes.ID INNER JOIN inventory_item_unit ON  inventory_item_unit_barcodes_link.FK_inventory_item_unit = inventory_item_unit.ID INNER JOIN inventory_item ON inventory_item_unit.FK_inventory_item = inventory_item.ID  INNER JOIN inventory_group ON inventory_item.fk_inventory_group = inventory_group.ID INNER JOIN inventory_profile ON inventory_group.fk_inventory_profile = inventory_profile.ID INNER JOIN config_display_profile ON  config_display_profile.FK_inventory_profile = inventory_profile.ID WHERE config_display_profile.account_type IN (? , 'ALL')AND config_display_profile.FK_config_terminal_location = ? AND inventory_item_unit_barcodes.barcode = ? AND inventory_item_unit.system_state = 'ACTIVE' ";
    public static final String QUERY_GET_ALL_BY_BARCODE = "SELECT DISTINCT inventory_item_unit.* FROM inventory_item_unit, inventory_item_unit_barcodes, inventory_item_unit_barcodes_link WHERE inventory_item_unit_barcodes.barcode = ? AND inventory_item_unit.system_state = 'ACTIVE' AND inventory_item_unit_barcodes_link.FK_inventory_item_unit = inventory_item_unit.ID AND inventory_item_unit_barcodes_link.FK_inventory_item_unit_barcodes = inventory_item_unit_barcodes.ID ";
    public static final String QUERY_GET_VALID = "SELECT inventory_item_unit.* FROM inventory_item_unit, inventory_item, inventory_group, inventory_profile WHERE " + SQL.join("inventory_item_unit", "inventory_item", "inventory_group", "inventory_profile") + "AND " + SQL.isActive("inventory_item_unit") + "AND " + SQL.isActive("inventory_item") + "AND " + SQL.isActive("inventory_group") + "AND " + SQL.isActive("inventory_profile");
    public static final String QUERY_GET_ALL = "SELECT inventory_item_unit.* FROM inventory_item_unit, inventory_item WHERE inventory_item_unit.FK_inventory_item = inventory_item.ID ORDER BY Name";

    public static InventoryItemUnit getInventoryUnitForItem(InventoryItem invItem, SystemState state) {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(InventoryItemUnit.class).equals(InventoryItemUnit.Properties.ITEM, invItem).equals(InventoryItemUnit.Properties.SYSTEM_STATE, state).limit(1);
        return PersistenceManager.getObject(InventoryItemUnit.class, oQuery.toString());
    }
}

