/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.inventory;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.inventory.InventoryOptionGroup;
import ordermate.database.queries.DomainQueries;

public class InventoryOptionQueries
implements DomainQueries {
    public static final ObjectQuery QUERY_GET_BY_NAME_SIZE = Query.select(InventoryOption.class).equalsParam(InventoryOption.Properties.LABEL).equalsParam(InventoryOptionGroup.Properties.SIZE).linkUsing(InventoryOption.Properties.OPTION_GROUP).orderBy(InventoryOption.Properties.SEQUENCE);

    public static ObjectQuery getAllActiveOptions() {
        return Query.select(InventoryOption.class).active(InventoryOption.class).orderBy(InventoryOption.Properties.LABEL);
    }

    public static InventoryOptionGroup getInventoryOptionGroupForNameAndSize(String label, InventoryItemSize size, SystemState state) {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(InventoryOptionGroup.class).equals(InventoryOptionGroup.Properties.LABEL, label).equals(InventoryOptionGroup.Properties.SYSTEM_STATE, state).limit(1);
        if (size != null) {
            oQuery.equals(InventoryOptionGroup.Properties.SIZE, size);
        }
        return PersistenceManager.getObject(InventoryOptionGroup.class, oQuery.toString());
    }

    public static InventoryOption getInventoryOptionForNameAndGroup(String label, InventoryOptionGroup optionGp, SystemState state) {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(InventoryOption.class).equals(InventoryOption.Properties.LABEL, label).equals(InventoryOption.Properties.SYSTEM_STATE, state);
        if (optionGp != null) {
            oQuery.equals(InventoryOption.Properties.OPTION_GROUP, optionGp);
        }
        return PersistenceManager.getObject(InventoryOption.class, oQuery.toString());
    }
}

