/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.inventory;

import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.DateTimeUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import ordermate.database.config.location.SalesLocation;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.queries.DomainQueries;

public class InventoryProfileQueries
implements DomainQueries {
    public static final String QUERY_GET_PROFILE_BY_TERMINAL = "SELECT inventory_profile.* FROM inventory_profile, config_display_profile, config_terminal_location, config_terminal WHERE config_display_profile.FK_inventory_profile = inventory_profile.ID AND config_display_profile.FK_config_terminal_location = config_terminal_location.ID AND config_terminal.FK_config_terminal_location = config_terminal_location.ID AND config_display_profile.system_state = 'ACTIVE' AND inventory_profile.system_state = 'ACTIVE' AND config_display_profile.account_type = ? AND config_terminal.ID = ?";
    public static final String QUERY_GET_ALL_PROFILES = "SELECT * FROM inventory_profile WHERE system_state = 'ACTIVE' ORDER BY Name";

    private static String addShiftFilterToQuery(String shifts) {
        if (shifts != null && !shifts.equals("Any")) {
            String[] shiftsArr = shifts.split(",");
            StringBuilder sb = new StringBuilder();
            sb.append("'").append(shiftsArr[0].trim()).append("'");
            if (shiftsArr.length > 1) {
                for (int i = 1; i < shiftsArr.length; ++i) {
                    sb.append(",");
                    sb.append("'").append(shiftsArr[i].trim()).append("'");
                }
            }
            return "JOIN sales_account ON sales_item.FK_sales_account = sales_account.ID JOIN finance_shift ON sales_account.FK_finance_shift = finance_shift.ID JOIN config_shift ON finance_shift.FK_config_shift = config_shift.ID AND config_shift.Name in (" + sb.toString() + ") ";
        }
        return "";
    }

    private static String addLocationsFilterToQuery(String locations) {
        if (locations != null && !locations.equals("Any")) {
            String[] locationsArr = locations.split(",");
            StringBuilder sb = new StringBuilder();
            sb.append(SalesLocation.getSalesLocationForName(locationsArr[0].trim()).getID());
            if (locationsArr.length > 1) {
                for (int i = 1; i < locationsArr.length; ++i) {
                    sb.append(",");
                    sb.append(SalesLocation.getSalesLocationForName(locationsArr[i].trim()).getID());
                }
            }
            return "sales_item_quantity.fk_config_sales_location in (" + sb.toString() + ")";
        }
        return null;
    }

    public static final class Reports {

        public static final class GetSalesAndCOGS {
            public static final int MENU_ITEM_NAME = 0;
            public static final int MENU_ITEM_UNIT_ID = 1;
            public static final int MENU_ITEM_UNIT_SYSTEM_STATE = 2;
            public static final int MENU_SIZE_NAME = 3;
            public static final int MENU_PORTION_NAME = 4;
            public static final int MENU_GROUP_NAME = 5;
            public static final int PRICE_LEVEL_NAME = 6;
            public static final int QTY_SOLD = 7;
            public static final int COGS = 8;
            public static final int SALES = 9;
            public static final int GP_VALUE = 10;
            public static final int GP_PERCENT = 11;
            public static final int SALES_EX_TAX = 12;
            private static final SelectQuery BASE_QUERY = new SelectQuery();

            @Deprecated
            public static SelectQuery getQueryPerItemUnit(InventoryProfile profile, List groups, InventoryItemUnit unit, Date from, Date to, String shifts, String locations, boolean showAll, boolean tradingDayFilter) {
                SelectQuery query = new SelectQuery(BASE_QUERY);
                query.addGroupBy("inventory_item_unit.ID");
                query.addOrderBy("inventory_item.Name", true);
                GetSalesAndCOGS.padQuery(query, profile, groups, unit, from, to, shifts, locations, showAll, tradingDayFilter);
                return query;
            }

            @Deprecated
            public static SelectQuery getQuery(InventoryProfile profile, List groups, InventoryItemUnit unit, Date from, Date to, String shifts, String locations, boolean showAll, boolean tradingDayFilter) {
                SelectQuery query = new SelectQuery(BASE_QUERY);
                if (profile != null) {
                    query.addGroupBy("inventory_item_unit.ID");
                } else if (groups != null) {
                    query.addGroupBy("inventory_group.ID");
                } else if (unit != null) {
                    query.addGroupBy("inventory_item_unit.ID");
                }
                GetSalesAndCOGS.padQuery(query, profile, groups, unit, from, to, shifts, locations, showAll, tradingDayFilter);
                return query;
            }

            private static void padQuery(SelectQuery query, InventoryProfile profile, List groups, InventoryItemUnit unit, Date from, Date to, String shifts, String locations, boolean showAll, boolean tradingDayFilter) {
                StringBuilder fromTableStr;
                String locsWhere;
                Timestamp sqlFrom = new Timestamp(from.getTime());
                Timestamp sqlTo = new Timestamp(to.getTime());
                if (unit != null) {
                    query.addWhere("inventory_item_unit.ID = " + unit.getID());
                }
                if (profile != null) {
                    query.addWhere("inventory_group.FK_inventory_profile = " + profile.getID());
                }
                if ((locsWhere = InventoryProfileQueries.addLocationsFilterToQuery(locations)) != null) {
                    query.addWhere(locsWhere);
                }
                if (groups != null && !groups.isEmpty()) {
                    String[] conditions = new String[groups.size()];
                    for (int i = 0; i < groups.size(); ++i) {
                        InventoryGroup group = (InventoryGroup)groups.get(i);
                        conditions[i] = "inventory_group.ID = " + group.getID();
                    }
                    query.addWhereOr(conditions);
                }
                if (!showAll) {
                    fromTableStr = new StringBuilder("");
                    fromTableStr.append("inventory_item_unit JOIN inventory_size ON inventory_item_unit.FK_inventory_size = inventory_size.ID JOIN inventory_portion ON inventory_item_unit.FK_inventory_portion = inventory_portion.ID JOIN inventory_item ON inventory_item_unit.FK_inventory_item = inventory_item.ID JOIN inventory_group ON inventory_item.FK_inventory_group = inventory_group.ID JOIN sales_component ON sales_component.FK_inventory_item_unit = inventory_item_unit.ID JOIN inventory_price_level ON sales_component.FK_inventory_price_level = inventory_price_level.ID JOIN sales_item ON sales_component.FK_sales_item = sales_item.ID ");
                    fromTableStr.append(InventoryProfileQueries.addShiftFilterToQuery(shifts));
                    fromTableStr.append("JOIN sales_item_quantity ON sales_item_quantity.FK_sales_item = sales_item.ID ");
                    if (tradingDayFilter) {
                        fromTableStr.append("JOIN finance_trading_day ON sales_item_quantity.FK_finance_trading_day = finance_trading_day.ID AND finance_trading_day.day >= '" + DateTimeUtils.getSQLDateFormat().format(from) + "' AND finance_trading_day.day <= '" + DateTimeUtils.getSQLDateFormat().format(to) + "' ");
                    } else {
                        fromTableStr.append("AND sales_item_quantity.creation_time >= '" + sqlFrom + "' AND sales_item_quantity.creation_time <= '" + sqlTo + "' ");
                    }
                    query.addFromTable(fromTableStr.toString());
                    query.addHaving("QtySold > 0");
                } else {
                    fromTableStr = new StringBuilder("");
                    fromTableStr.append("inventory_item_unit JOIN inventory_size ON inventory_item_unit.FK_inventory_size = inventory_size.ID JOIN inventory_portion ON inventory_item_unit.FK_inventory_portion = inventory_portion.ID JOIN inventory_item ON inventory_item_unit.FK_inventory_item = inventory_item.ID JOIN inventory_group ON inventory_item.FK_inventory_group = inventory_group.ID LEFT JOIN sales_component ON sales_component.FK_inventory_item_unit = inventory_item_unit.ID LEFT JOIN inventory_price_level ON sales_component.FK_inventory_price_level = inventory_price_level.ID LEFT JOIN sales_item ON sales_component.FK_sales_item = sales_item.ID " + InventoryProfileQueries.addShiftFilterToQuery(shifts) + "LEFT JOIN sales_item_quantity ON sales_item_quantity.FK_sales_item = sales_item.ID ");
                    if (tradingDayFilter) {
                        fromTableStr.append("JOIN finance_trading_day ON sales_item_quantity.FK_finance_trading_day = finance_trading_day.ID AND finance_trading_day.day >= '" + DateTimeUtils.getSQLDateFormat().format(from) + "' AND finance_trading_day.day <= '" + DateTimeUtils.getSQLDateFormat().format(to) + "' ");
                    } else {
                        fromTableStr.append("AND sales_item_quantity.creation_time >= '" + sqlFrom + "' AND sales_item_quantity.creation_time <= '" + sqlTo + "' ");
                    }
                    query.addFromTable(fromTableStr.toString());
                    query.addHaving("QtySold > 0 OR inventory_item_unit.system_state = 'ACTIVE'");
                }
            }

            static {
                BASE_QUERY.addSelectValue("inventory_item.Name");
                BASE_QUERY.addSelectValue("inventory_item_unit.ID");
                BASE_QUERY.addSelectValue("inventory_item_unit.system_state");
                BASE_QUERY.addSelectValue("inventory_size.Name");
                BASE_QUERY.addSelectValue("inventory_portion.Name");
                BASE_QUERY.addSelectValue("inventory_group.Name");
                BASE_QUERY.addSelectValue("inventory_price_level.Name");
                BASE_QUERY.addSelectValue("SUM(sales_item_quantity.quantity) AS QtySold");
                BASE_QUERY.addSelectValue("SUM(sales_component.unit_cost * sales_item_quantity.quantity) AS COGS");
                BASE_QUERY.addSelectValue("SUM(sales_component.unit_price * sales_item_quantity.quantity) AS Sales");
                BASE_QUERY.addSelectValue("SUM((sales_component.unit_price - sales_component.unit_tax - sales_component.unit_cost) * sales_item_quantity.quantity) AS GPValue");
                BASE_QUERY.addSelectValue("SUM((sales_component.unit_price - sales_component.unit_tax - sales_component.unit_cost) * sales_item_quantity.quantity) * 100 / SUM((sales_component.unit_price - sales_component.unit_tax) * sales_item_quantity.quantity) AS GPPercent ");
                BASE_QUERY.addSelectValue("SUM((sales_component.unit_price - sales_component.unit_tax) * sales_item_quantity.quantity) AS SalesExTax ");
            }
        }
    }
}

