/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.inventory;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.Literal;
import au.com.ordermate.sql.queries.Operator;
import au.com.ordermate.sql.queries.SQLColumn;
import au.com.ordermate.sql.queries.SelectQuery;
import java.util.List;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.AccountTypeTrigger;
import ordermate.database.inventory.triggers.DefaultTrigger;
import ordermate.database.inventory.triggers.UserTrigger;
import ordermate.database.queries.DomainQueries;
import ordermate.database.users.PermissionGroup;

public class TriggerQueries
implements DomainQueries {
    public static final String GET_USES_OF_LEVEL = "SELECT SUM(sales_item_quantity.quantity) AS num_components FROM sales_item, sales_component, sales_item_quantity WHERE sales_component.FK_sales_item = sales_item.ID AND sales_item_quantity.FK_sales_item = sales_item.ID AND sales_item.FK_sales_customer = ? AND sales_component.FK_inventory_price_level = ? AND sales_item_quantity.FK_finance_trading_day = ? ";
    public static final String GET_USES_OF_LEVEL_EXCLUDING_ACCOUNT = "SELECT SUM(sales_item_quantity.quantity) AS num_components FROM sales_item, sales_component, sales_item_quantity WHERE sales_component.FK_sales_item = sales_item.ID AND sales_item_quantity.FK_sales_item = sales_item.ID AND sales_item.FK_sales_customer = ? AND sales_component.FK_inventory_price_level = ? AND sales_item_quantity.FK_finance_trading_day = ? AND NOT (sales_item.FK_sales_account = ?)";

    public static <T extends AbstractTrigger> List<T> getAllTriggersOfType(Class<T> triggerType) {
        ObjectQuery query = Query.select(triggerType).active(triggerType).instanceOf(triggerType);
        return PersistenceManager.getObjectList(triggerType, query.toString());
    }

    public static final SelectQuery getAllTriggersExcluding() {
        SelectQuery query = SQL.createQuery("inventory_trigger");
        query.addSelectValue("ID");
        query.addSelectValue("Name");
        query.addSelectValue("Type");
        query.addWhere(new SQLColumn("inventory_trigger", "FK_parent_trigger"), Operator.IS_NULL);
        query.addWhere(new SQLColumn("inventory_trigger", "system_state"), Operator.NOT_EQUALS, Literal.getAddQuotes("DELETED"));
        query.addWhere(new SQLColumn("inventory_trigger", "Type"), Operator.NOT_EQUALS, Literal.getAddQuotes(AbstractTrigger.Types.TRADING_DAY_TYPE.toString()));
        return query;
    }

    public static ObjectQuery getUserTriggerForPermissionGp(int permissionGroupId) {
        return Query.select(UserTrigger.class).active(UserTrigger.class).instanceOf(UserTrigger.class).whereFunction(" FK_config_permission_group = " + permissionGroupId).limit(1);
    }

    public static ObjectQuery getUserTriggerWithPermissionLevel(int permissionLevel) {
        return Query.select(UserTrigger.class).active(UserTrigger.class).instanceOf(UserTrigger.class).linkUsing(UserTrigger.Properties.PERMISSION_GROUP, PermissionGroup.Properties.ID).equals(PermissionGroup.Properties.LEVEL, permissionLevel).active(PermissionGroup.class).limit(1);
    }

    public static ObjectQuery getDefaultTriggerWithLabelAndType(String Label) {
        return Query.select(DefaultTrigger.class).active(DefaultTrigger.class).instanceOf(DefaultTrigger.class).equals(DefaultTrigger.Properties.LABEL, Label).limit(1);
    }

    public static ObjectQuery getAccountTypeTriggerWithLabelAndType(String Label) {
        return Query.select(AccountTypeTrigger.class).active(AccountTypeTrigger.class).instanceOf(AccountTypeTrigger.class).equals(AccountTypeTrigger.Properties.LABEL, Label).limit(1);
    }
}

