/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.inventory;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.SelectQuery;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.UnitPriceLevel;
import ordermate.database.queries.DomainQueries;

public class UnitPriceLevelQueries
implements DomainQueries {
    public static ObjectQuery getUnitPriceLevel(InventoryItemUnit unit, PriceLevel level) {
        return Query.select(UnitPriceLevel.class).equals(UnitPriceLevel.Properties.UNIT, unit).equals(UnitPriceLevel.Properties.PRICE_LEVEL, level);
    }

    public static final class EditPrices {
        public static final String UNIT_ID = "inventory_item_unit.ID";
        public static final String INVENTORY_GROUP_NAME = "inventory_group.Name";
        public static final String INVENTORY_ITEM_NAME = "inventory_item.Name";
        public static final String INVENTORY_PORTION_NAME = "inventory_portion.Name";
        public static final String INVENTORY_SIZE_NAME = "inventory_size.Name";
        public static final String TAX_CODE = "inventory_item_unit_tax.FK_system_tax_code";

        public static SelectQuery createQuery(String[] priceLevels) {
            SelectQuery query = SQL.createQuery("inventory_item INNER JOIN inventory_item_unit ON inventory_item_unit.FK_inventory_item = inventory_item.ID INNER JOIN inventory_unit_price_level_link ON inventory_unit_price_level_link.FK_inventory_item_unit = inventory_item_unit.ID RIGHT JOIN inventory_price_level ON inventory_unit_price_level_link.FK_inventory_price_level = inventory_price_level.ID JOIN inventory_size ON inventory_item_unit.FK_inventory_size = inventory_size.ID JOIN inventory_portion ON inventory_item_unit.FK_inventory_portion = inventory_portion.ID JOIN inventory_group ON inventory_item.FK_inventory_group = inventory_group.ID JOIN inventory_profile ON inventory_group.FK_inventory_profile = inventory_profile.ID JOIN inventory_item_unit_tax ON inventory_item_unit.ID = inventory_item_unit_tax.fk_inventory_item_unit");
            query.addSelectValue(UNIT_ID);
            query.addSelectValue(INVENTORY_GROUP_NAME);
            query.addSelectValue(INVENTORY_ITEM_NAME);
            query.addSelectValue(INVENTORY_PORTION_NAME);
            query.addSelectValue(INVENTORY_SIZE_NAME);
            query.addSelectValue(TAX_CODE);
            for (int i = 0; i < priceLevels.length; ++i) {
                String level = priceLevels[i];
                query.addSelectValue("MIN(IF(inventory_price_level.Name = '" + level + "', inventory_unit_price_level_link.price, null)) as '" + level + "'");
            }
            query.addImmutableWhere("inventory_item_unit.system_state != 'DELETED'");
            query.addImmutableWhere("inventory_item.system_state != 'DELETED'");
            query.addImmutableWhere("inventory_price_level.system_state != 'DELETED'");
            query.addGroupBy(UNIT_ID);
            query.addOrderBy(INVENTORY_GROUP_NAME, true);
            query.addOrderBy(INVENTORY_ITEM_NAME, true);
            return query;
        }

        public static String rawQuery() {
            return "SELECT inventory_item_unit.ID, inventory_group.Name, inventory_item.Name, inventory_portion.Name, inventory_size.Name, inventory_item_unit_tax.FK_system_tax_code, MIN(IF(inventory_price_level.Name = 'Student Special', inventory_unit_price_level_link.price, null)) as 'Student Special', MIN(IF(inventory_price_level.Name = 'TableOrder', inventory_unit_price_level_link.price, null)) as 'TableOrder'\nFROM inventory_item \nJOIN inventory_item_unit ON inventory_item_unit.FK_inventory_item = inventory_item.ID \nJOIN inventory_unit_price_level_link ON  inventory_item_unit.ID  = inventory_unit_price_level_link.FK_inventory_item_unit\nJOIN inventory_price_level ON inventory_unit_price_level_link.FK_inventory_price_level = inventory_price_level.ID \nJOIN inventory_size ON inventory_item_unit.FK_inventory_size = inventory_size.ID \nJOIN inventory_portion ON inventory_item_unit.FK_inventory_portion = inventory_portion.ID \nJOIN inventory_group ON inventory_item.FK_inventory_group = inventory_group.ID \nJOIN inventory_profile ON inventory_group.FK_inventory_profile = inventory_profile.ID \nJOIN inventory_item_unit_tax ON inventory_item_unit.ID = inventory_item_unit_tax.fk_inventory_item_unit \nWHERE inventory_profile.ID = '1'  AND inventory_item_unit.system_state != 'DELETED'  AND inventory_item.system_state != 'DELETED'  AND inventory_price_level.system_state != 'DELETED' \nGROUP BY 1\nUNION\nSELECT inventory_item_unit.ID, inventory_group.Name, inventory_item.Name, inventory_portion.Name, inventory_size.Name, inventory_item_unit.FK_system_tax_code, null as 'Student Special', null as 'TableOrder' \nFROM (inventory_item, inventory_unit_price_level_link)\nJOIN inventory_item_unit ON inventory_item_unit.FK_inventory_item = inventory_item.ID \nJOIN inventory_size ON inventory_item_unit.FK_inventory_size = inventory_size.ID \nJOIN inventory_portion ON inventory_item_unit.FK_inventory_portion = inventory_portion.ID \nJOIN inventory_group ON inventory_item.FK_inventory_group = inventory_group.ID \nJOIN inventory_profile ON inventory_group.FK_inventory_profile = inventory_profile.ID \nWHERE  inventory_item_unit.ID  not in (SELECT FK_inventory_item_unit FROM inventory_unit_price_level_link)  AND inventory_profile.ID = '1'  AND inventory_item_unit.system_state != 'DELETED'  AND inventory_item.system_state != 'DELETED' \nGROUP BY 1 ORDER BY 2 ASC , 3 ASC";
        }
    }
}

