/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.misc;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.sql.SQL;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Date;
import java.util.List;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.DomainQueries;

public class TradingDayQueries
implements DomainQueries {
    public static final String GET_CURRENT_TRADING_DAY = "SELECT finance_trading_day.* FROM system_current_info, finance_trading_day WHERE system_current_info.FK_finance_trading_day = finance_trading_day.ID";
    public static final String GET_ALL_TRADING_DAYS = "SELECT * FROM finance_trading_day ORDER BY day DESC LIMIT 365";
    public static final String GET_NUM_SALES = "SELECT SUM(sales_item_quantity.quantity) FROM sales_component, inventory_item_unit, sales_item, sales_account, sales_item_quantity WHERE inventory_item_unit.external_id = ? AND inventory_item_unit.external_id > 0 AND sales_account.FK_finance_trading_day = ? AND " + SQL.join("sales_component", "inventory_item_unit") + "AND " + SQL.join("sales_component", "sales_item") + "AND " + SQL.join("sales_item_quantity", "sales_item") + "AND " + SQL.join("sales_item", "sales_account");
    public static final String GET_SURCHARGE_FOR_DAY = "SELECT config_price_adjustment.* FROM config_price_adjustment, finance_trading_day WHERE finance_trading_day.day = config_price_adjustment.date AND finance_trading_day.ID = ?";
    public static final String UPDATE_CURRENT_TRADING_DAY = "UPDATE system_current_info SET FK_finance_trading_day = ?";

    public static List<TradingDay> getTradingDaysBetweenDates(Date start, Date end) {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(TradingDay.class);
        if (start != null && end != null) {
            oQuery.wherePropertyBetween(TradingDay.Properties.DATE, start, end, SQLDateType.DATE);
            oQuery.orderBy(TradingDay.Properties.DATE);
        }
        return PersistenceManager.getObjectList(TradingDay.class, oQuery.toString());
    }

    public static List<TradingDay> getClosedTradingDaysExStartIncEnd(Date start, Date end) {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(TradingDay.class);
        if (start != null && end != null) {
            oQuery.greaterThan(TradingDay.Properties.DATE, start, SQLDateType.DATE).lessThanOrEqual(TradingDay.Properties.DATE, end, SQLDateType.DATE).not().isNull(TradingDay.Properties.CLOSE_DATE).not().isNull(TradingDay.Properties.CLOSE_TIME).orderBy(TradingDay.Properties.DATE);
        }
        return PersistenceManager.getObjectList(TradingDay.class, oQuery.toString());
    }

    public static TradingDay getLastClosedTradingDay() {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(TradingDay.class).not().isNull(TradingDay.Properties.CLOSE_DATE).not().isNull(TradingDay.Properties.CLOSE_TIME).orderByDesc(TradingDay.Properties.DATE);
        return PersistenceManager.getObject(TradingDay.class, oQuery.toString());
    }

    public static TradingDay getTradingDay(Date date) {
        ObjectQuery oQuery = new ObjectQuery();
        oQuery.select(TradingDay.class);
        if (date == null) {
            return null;
        }
        oQuery.equals(TradingDay.Properties.DATE, date, SQLDateType.DATE);
        return PersistenceManager.getObject(TradingDay.class, oQuery.toString());
    }

    public TradingDayQueries(String string, Class<TradingDay> class1) {
    }

    public static TradingDay getTradingDayOnOrBefore(Date relativeDate) {
        return PersistenceManager.getObject(TradingDay.class, Query.select(TradingDay.class).lessThanOrEqual(TradingDay.Properties.DATE, relativeDate, SQLDateType.DATE).orderBy(TradingDay.Properties.DATE, true).limit(1).toString());
    }

    public static TradingDay getTradingDayForDateAndTime(Date date) {
        String dateString = DateTimeUtils.getSQLTimestampFormat().format(date);
        String previousDaysQuery = "'" + dateString + "' between TIMESTAMP (day, time) and TIMESTAMP (close_day, close_time)";
        String currentDayQuery = "'" + dateString + "' >= TIMESTAMP (day, time) and (close_day is null and close_time is null) ";
        return PersistenceManager.getObject(TradingDay.class, Query.select(TradingDay.class).whereFunction(previousDaysQuery).or().whereFunction(currentDayQuery).toString());
    }
}

