/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.reports;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.SalesItemPriceAdjustmentLink;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.DomainQueries;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesPriceAdjustmentUsage;
import ordermate.database.users.User;

public class AdjustmentsReportQueries
implements DomainQueries {
    public static ObjectQuery getAccountQuery() {
        return Query.select(SalesPriceAdjustment.Properties.ID).select(SalesPriceAdjustmentUsage.Properties.USER, "fk_config_user").sum(SalesPriceAdjustmentUsage.Properties.SAVED_TOTAL_VALUE, "saved_total_value").selectFunc("null as quantity").select(SalesPriceAdjustmentUsage.Properties.CREATION_TIME, "creation_time").select(SalesPriceAdjustment.Properties.TYPE, "type").select(SalesPriceAdjustment.Properties.LABEL, "name").select(SalesPriceAdjustment.Properties.UNIT, "unit").select(SalesPriceAdjustment.Properties.LEVEL, "level").select(SalesPriceAdjustment.Properties.SOURCE, "source").selectFunc("sales_price_adjustment.amount").select(Account.Properties.ACCOUNT_TYPE, "account_type").select("No Inventory Item", "item_name").selectFunc("NULL as fk_inventory_item_unit").select(TradingDay.Properties.DATE, "trading_day_date").selectFunc("NULL as fk_inventory_portion").selectFunc("NULL as size").selectFunc("NULL as fk_sales_item").selectFunc("0 as mod_count").linkUsing(SalesPriceAdjustment.Properties.ACCOUNT, Account.Properties.ID).linkUsing(SalesPriceAdjustmentUsage.Properties.SALES_PRICE_ADJUSTMENT, SalesPriceAdjustment.Properties.ID).linkUsing(SalesPriceAdjustmentUsage.Properties.SALES_COMPONENT, SalesComponent.Properties.ID).linkUsing(SalesPriceAdjustmentUsage.Properties.USER, User.Properties.ID).linkUsing(SalesPriceAdjustment.Properties.TRADING_DAY, TradingDay.Properties.ID).equals(SalesPriceAdjustment.Properties.LEVEL, PriceAdjustmentLevel.ACCOUNT_LEVEL).whereFunction("saved_total_value <> 0").groupBy(SalesPriceAdjustment.Properties.ID);
    }

    public static ObjectQuery getItemQuery() {
        return Query.select(SalesPriceAdjustment.Properties.ID, "ID").select(SalesPriceAdjustmentUsage.Properties.USER, "fk_config_user").select(SalesPriceAdjustmentUsage.Properties.SAVED_TOTAL_VALUE, "saved_total_value").sum(SalesItemQuantity.Properties.QUANTITY, "quantity").select(SalesItemQuantity.Properties.CREATION_TIME, "creation_time").select(SalesPriceAdjustment.Properties.TYPE, "type").select(SalesPriceAdjustment.Properties.LABEL, "name").select(SalesPriceAdjustment.Properties.UNIT, "unit").select(SalesPriceAdjustment.Properties.LEVEL, "level").select(SalesPriceAdjustment.Properties.SOURCE, "source").selectFunc("sales_price_adjustment.amount as amount").select("No Account Type", "account_type").select(InventoryItem.Properties.LABEL, "item_name").select(SalesComponent.Properties.UNIT, "fk_inventory_item_unit").select(TradingDay.Properties.DATE, "trading_day_date").select(InventoryItemUnit.Properties.PORTION, "fk_inventory_portion").select(InventoryItemSize.Properties.LABEL, "size").select(SalesComponent.Properties.SALES_ITEM, "fk_sales_item").selectFunc("0 as mod_count").linkUsing(SalesPriceAdjustmentUsage.Properties.SALES_PRICE_ADJUSTMENT, SalesPriceAdjustment.Properties.ID).linkUsing(SalesPriceAdjustmentUsage.Properties.SALES_COMPONENT, SalesComponent.Properties.ID).linkUsing(SalesPriceAdjustmentUsage.Properties.USER, User.Properties.ID).linkUsing(SalesComponent.Properties.INVENTORY_ITEM, InventoryItem.Properties.ID).linkUsing(SalesPriceAdjustment.Properties.TRADING_DAY, TradingDay.Properties.ID).linkUsing(SalesComponent.Properties.SALES_ITEM, SalesItem.Properties.ID).linkUsing(SalesComponent.Properties.UNIT, InventoryItemUnit.Properties.ID).linkUsing(InventoryItemUnit.Properties.SIZE).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).equals(SalesPriceAdjustment.Properties.LEVEL, PriceAdjustmentLevel.ITEM_LEVEL).whereFunction("saved_total_value <> 0").groupBy(SalesItem.Properties.ID).groupBy(SalesPriceAdjustment.Properties.ID);
    }

    public static ObjectQuery getPerUnitQuery() {
        return Query.select(SalesPriceAdjustment.Properties.ID, "ID").select(SalesPriceAdjustmentUsage.Properties.USER, "fk_config_user").select(SalesPriceAdjustmentUsage.Properties.SAVED_TOTAL_VALUE, "saved_total_value").sum(SalesItemQuantity.Properties.QUANTITY, "quantity").select(SalesPriceAdjustmentUsage.Properties.CREATION_TIME, "creation_time").select(SalesPriceAdjustment.Properties.TYPE, "type").select(SalesPriceAdjustment.Properties.LABEL, "name").select(SalesPriceAdjustment.Properties.UNIT, "unit").select(SalesPriceAdjustment.Properties.LEVEL, "level").selectFunc("sales_price_adjustment.amount as amount").select(Account.Properties.ACCOUNT_TYPE, "account_type").select(InventoryItem.Properties.LABEL, "item_name").select(SalesComponent.Properties.UNIT, "fk_inventory_item_unit").select(TradingDay.Properties.DATE, "trading_day_date").select(InventoryItemUnit.Properties.PORTION, "fk_inventory_portion").select(InventoryItemSize.Properties.LABEL, "size").select(SalesComponent.Properties.SALES_ITEM, "fk_sales_item").select(SalesPriceAdjustment.Properties.SOURCE, "source").selectFunc("0 as mod_count").linkUsing(SalesPriceAdjustmentUsage.Properties.SALES_PRICE_ADJUSTMENT, SalesPriceAdjustment.Properties.ID).linkUsing(SalesPriceAdjustmentUsage.Properties.SALES_COMPONENT, SalesComponent.Properties.ID).linkUsing(SalesPriceAdjustmentUsage.Properties.USER, User.Properties.ID).linkUsing(SalesComponent.Properties.INVENTORY_ITEM, InventoryItem.Properties.ID).linkUsing(SalesPriceAdjustment.Properties.TRADING_DAY, TradingDay.Properties.ID).linkUsing(SalesComponent.Properties.SALES_ITEM, SalesItem.Properties.ID).linkUsing(SalesItem.Properties.ACCOUNT, Account.Properties.ID).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesComponent.Properties.UNIT, InventoryItemUnit.Properties.ID).linkUsing(InventoryItemUnit.Properties.SIZE).whereFunction("saved_total_value <> 0").groupBy(SalesComponent.Properties.ID).groupBy(SalesPriceAdjustment.Properties.ID);
    }

    public static ObjectQuery getItemLevelAdjustmentForAccount(Account account, PriceAdjustmentDirection direction) {
        return Query.select(SalesPriceAdjustment.Properties.ID, "ID").select(SalesPriceAdjustmentUsage.Properties.USER, "fk_config_user").sum(SalesPriceAdjustmentUsage.Properties.SAVED_TOTAL_VALUE, "saved_total_value").select(SalesPriceAdjustmentUsage.Properties.CREATION_TIME, "creation_time").selectFunc("null as quantity").select(SalesPriceAdjustment.Properties.TYPE, "type").select(SalesPriceAdjustment.Properties.LABEL, "name").select(SalesPriceAdjustment.Properties.UNIT, "unit").select(SalesPriceAdjustment.Properties.LEVEL, "level").select(SalesPriceAdjustment.Properties.SOURCE, "source").selectFunc("sales_price_adjustment.amount as amount").select(InventoryItem.Properties.LABEL, "item_name").select(SalesComponent.Properties.UNIT, "fk_inventory_item_unit").select(InventoryItemUnit.Properties.PORTION, "fk_inventory_portion").select(SalesComponent.Properties.SALES_ITEM, "fk_sales_item").selectFunc("NULL as size").select(TradingDay.Properties.DATE, "trading_day_date").select("No Account Type", "account_type").selectFunc("0 as mod_count").linkUsing(SalesPriceAdjustmentUsage.Properties.SALES_PRICE_ADJUSTMENT, SalesPriceAdjustment.Properties.ID).linkUsing(SalesItemPriceAdjustmentLink.Properties.SALES_PRICE_ADJUSTMENT, SalesPriceAdjustment.Properties.ID).linkUsing(SalesItemPriceAdjustmentLink.Properties.SALES_LINE_ITEM, SalesItem.Properties.ID).linkUsing(SalesItem.Properties.ACCOUNT, Account.Properties.ID).linkUsing(SalesItem.Properties.COMPONENT, SalesComponent.Properties.ID).linkUsing(SalesComponent.Properties.INVENTORY_ITEM, InventoryItem.Properties.ID).linkUsing(SalesComponent.Properties.UNIT, InventoryItemUnit.Properties.ID).linkUsing(SalesPriceAdjustment.Properties.TRADING_DAY, TradingDay.Properties.ID).linkUsing(SalesPriceAdjustmentUsage.Properties.SALES_COMPONENT, SalesComponent.Properties.ID).wherePropertyLike(Account.Properties.ID, account.getID().toString()).equals(SalesPriceAdjustment.Properties.DIRECTION, direction).groupBy(SalesItem.Properties.ID).groupBy(SalesPriceAdjustment.Properties.ID).orderBy(Account.Properties.ID, true);
    }
}

