/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.reports;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import java.util.List;
import ordermate.database.finance.Skim;
import ordermate.database.finance.SkimTransaction;
import ordermate.database.finance.reconciliation.ShiftReconciliation;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.misc.SystemProperty;
import ordermate.database.users.User;

public class CashdrawerReconciliationQueries {
    private static String[] txnSystemStates = new String[]{"ACTIVE", "MOVED"};

    public static ObjectQuery getSystemTips(ShiftReconciliation recon, CashDrawer drawer) {
        ObjectQuery query = Query.selectFunc("1 as 'ID'").selectFunc("SUM(" + FinanceTransaction.Properties.TIP + ") AS price").wherePropertyIn(FinanceTransaction.Properties.SYSTEM_STATE, txnSystemStates).isNull(FinanceTransaction.Properties.MOVED_TRANSACTION).equals(FinanceTransaction.Properties.SHIFT, recon.getShift().getID()).equals(FinanceTransaction.Properties.CASH_DRAWER, drawer.getID());
        return query;
    }

    public static ObjectQuery getSystemCashOut(ShiftReconciliation recon, CashDrawer drawer) {
        ObjectQuery query = Query.selectFunc("1 as 'ID'").selectFunc("SUM(" + FinanceTransaction.Properties.CASH_OUT + ") as price").isNull(FinanceTransaction.Properties.MOVED_TRANSACTION).equals(FinanceTransaction.Properties.SHIFT, recon.getShift().getID()).equals(FinanceTransaction.Properties.CASH_DRAWER, drawer.getID()).wherePropertyIn(FinanceTransaction.Properties.SYSTEM_STATE, txnSystemStates);
        return query;
    }

    public static ObjectQuery getTotalSkims(ShiftReconciliation recon, CashDrawer drawer) {
        ObjectQuery query = Query.select(SkimTransaction.Properties.ID).sum(SkimTransaction.Properties.AMOUNT, "price").linkUsing(SkimTransaction.Properties.SKIM).equals(Skim.Properties.CASH_DRAWER, drawer).active(SkimTransaction.class).equals(Skim.Properties.SHIFT, recon.getShift());
        return query;
    }

    public static ObjectQuery getReconciliationUsers(ShiftReconciliation recon, CashDrawer drawer) {
        ObjectQuery query = Query.select(User.class).linkUsing(FinanceTransaction.Properties.USER).equals(FinanceTransaction.Properties.CASH_DRAWER, drawer.getID()).equals(FinanceTransaction.Properties.SHIFT, recon.getShift().getID()).groupBy(FinanceTransaction.Properties.USER);
        return query;
    }

    public static ObjectQuery getSystemFinanceTotal(ShiftReconciliation recon, CashDrawer drawer, List<String> financeUnitTypes) {
        String sumQuery = "SUM(" + FinanceTransaction.Properties.PAID + ") as price";
        if (SystemProperty.getInstance().isReconciliationSystemTotalIncludesTips()) {
            sumQuery = "SUM(" + FinanceTransaction.Properties.PAID + " + " + FinanceTransaction.Properties.TIP + ") as price";
        }
        ObjectQuery query = Query.select("1", "ID").selectFunc(sumQuery).equals(FinanceTransaction.Properties.SHIFT, recon.getShift().getID()).wherePropertyIn(FinanceUnit.Properties.TYPE, financeUnitTypes).equals(FinanceTransaction.Properties.CASH_DRAWER, drawer.getID()).wherePropertyIn(FinanceTransaction.Properties.SYSTEM_STATE, txnSystemStates).isNull(FinanceTransaction.Properties.MOVED_TRANSACTION).linkUsing(FinanceTransaction.Properties.SUB_TYPE);
        return query;
    }
}

