/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.reports;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import ordermate.database.finance.Shift;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.hardware.physical.CashDrawer;

public abstract class DebtorGroupTakingsQueries {
    public static final String NETT_ADDED_COL = "added";
    public static final String NETT_PAID_COL = "paid";
    public static final String DISCOUNTED_COL = "discounted";
    public static final String SURCHARGEDED_COL = "surcharged";
    public static final String REFUNDED_SALES_COL = "refunded_sales";
    public static final String REFUNDED_PAYMENTS_COL = "refunded_payments";
    public static final String ADJUSTMENTS = "adjustments";

    public static ObjectQuery getSummaryForShiftAndCashDrawer(Shift financeShift, CashDrawer cashDrawer) {
        ObjectQuery querySales = DebtorGroupTakingsQueries.getDebtorSalesForShiftAndCashDrawer(financeShift, cashDrawer);
        ObjectQuery queryPayments = DebtorGroupTakingsQueries.getDebtorPaymentsForShiftAndCashDrawer(financeShift, cashDrawer);
        ObjectQuery queryAdjustments = DebtorGroupTakingsQueries.getDebtorAdjustmentsForShiftAndCashDrawer(financeShift, cashDrawer);
        return querySales.union(queryPayments).union(queryAdjustments);
    }

    public static ObjectQuery getDebtorSalesForShiftAndCashDrawer(Shift financeShift, CashDrawer cashDrawer) {
        ObjectQuery querySales = Query.select(DebtorSale.Properties.DEBTOR).select(AbstractDebtor.Properties.GROUP).select(DebtorSale.Properties.CASHDRAWER).selectFunc("SUM(debtor_sale.total) AS added").selectFunc("0.00 AS paid").selectFunc("0.00 AS discounted").selectFunc("0.00 AS surcharged").selectFunc("SUM(IF(sales_account.account_type = 'REFUND', debtor_sale.total, 0)) AS refunded_sales").selectFunc("0.00 AS refunded_payments").selectFunc("0.00 AS adjustments").linkUsing(DebtorSale.Properties.DEBTOR).linkUsing(AbstractDebtor.Properties.GROUP).linkUsing(DebtorSale.Properties.CASHDRAWER).linkUsing(DebtorSale.Properties.SALE_ACCOUNT).equals(DebtorSale.Properties.SHIFT, financeShift.getID());
        if (cashDrawer != null) {
            querySales.equals(DebtorSale.Properties.CASHDRAWER, cashDrawer.getID());
        }
        querySales.groupBy(AbstractDebtor.Properties.ID).groupBy(AbstractDebtor.Properties.GROUP);
        return querySales;
    }

    public static ObjectQuery getDebtorPaymentsForShiftAndCashDrawer(Shift financeShift, CashDrawer cashDrawer) {
        ObjectQuery queryPayments = Query.select(DebtorPayment.Properties.DEBTOR).select(AbstractDebtor.Properties.GROUP).select(DebtorPayment.Properties.CASHDRAWER).selectFunc(" 0.00 AS added").selectFunc("SUM( IF (debtor_payment.amount <= 0 AND finance_transaction.amount_paid > 0 AND finance_transaction.type <> 'ACCOUNT' AND finance_transaction.system_state = 'MOVED', finance_transaction.amount_paid, debtor_payment.amount)) AS paid").selectFunc("SUM( IF (finance_transaction.amount_paid > 0 AND finance_transaction.type = 'ACCOUNT', debtor_payment.amount, 0)) AS discounted").selectFunc("SUM( IF (finance_transaction.amount_paid < 0 AND finance_transaction.type = 'ACCOUNT', debtor_payment.amount, 0)) AS surcharged").selectFunc("0.00 AS refunded_sales").selectFunc("SUM( IF(finance_transaction.amount_paid < 0, debtor_payment.amount, 0)) AS refunded_payments").selectFunc("0.00 AS adjustments").linkUsing(DebtorPayment.Properties.DEBTOR).linkUsing(AbstractDebtor.Properties.GROUP).linkUsing(DebtorPayment.Properties.CASHDRAWER).linkUsing(DebtorPayment.Properties.FINANCE_TRANSACTION).equals(DebtorPayment.Properties.SHIFT, financeShift.getID());
        if (cashDrawer != null) {
            queryPayments.equals(DebtorPayment.Properties.CASHDRAWER, cashDrawer.getID());
        }
        queryPayments.groupBy(AbstractDebtor.Properties.ID).groupBy(AbstractDebtor.Properties.GROUP);
        return queryPayments;
    }

    public static ObjectQuery getDebtorAdjustmentsForShiftAndCashDrawer(Shift financeShift, CashDrawer cashDrawer) {
        ObjectQuery queryAdjustments = Query.select(DebtorPayment.Properties.DEBTOR).select(AbstractDebtor.Properties.GROUP).select(DebtorPayment.Properties.CASHDRAWER).selectFunc(" 0.00 AS added").selectFunc("0.00 AS paid").selectFunc("0.00 AS discounted").selectFunc("0.00 AS surcharged").selectFunc("0.00 AS refunded_sales").selectFunc("0.00 AS refunded_payments").selectFunc("SUM( IF (finance_transaction.type = 'ACCOUNT' AND finance_unit.unit_type = 'ACCOUNT' AND finance_unit.Name = 'Debtor Adjustment', debtor_payment.amount, 0)) AS adjustments").linkUsing(DebtorPayment.Properties.DEBTOR).linkUsing(AbstractDebtor.Properties.GROUP).linkUsing(DebtorPayment.Properties.CASHDRAWER).linkUsing(DebtorPayment.Properties.FINANCE_TRANSACTION).linkUsing(FinanceTransaction.Properties.SUB_TYPE).equals(DebtorPayment.Properties.SHIFT, financeShift.getID());
        if (cashDrawer != null) {
            queryAdjustments.equals(DebtorPayment.Properties.CASHDRAWER, cashDrawer.getID());
        }
        queryAdjustments.groupBy(AbstractDebtor.Properties.ID).groupBy(AbstractDebtor.Properties.GROUP);
        return queryAdjustments;
    }
}

