/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.sales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.finance.Shift;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.misc.EventLogRecord;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TradingDay;
import ordermate.database.misc.enums.DeterminePatrons;
import ordermate.database.reports.general.PriceReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.BarTabAccount;
import ordermate.database.sales.Customer;
import ordermate.database.sales.SalesCombo;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesPriceAdjustmentUsage;
import ordermate.integration.jaxb.online.sales.OrderMateSale;

public abstract class AccountQueries {
    public static final String OPEN = "OPEN";
    public static final String CLOSED = "CLOSED";
    public static final String GET_USER_ID = "SELECT sales_account.FK_config_user FROM sales_account WHERE sales_account.ID = ? ";
    public static final String GET_ACCOUNTS_FOR_SHIFT_STATUS = "SELECT sales_account.* FROM sales_account WHERE sales_account.FK_finance_shift = ? AND account_type = ? AND sales_account.account_state = ? ORDER BY creation_time";
    public static final String GET_ACCOUNTS_FOR_TYPE = "SELECT sales_account.* FROM sales_account WHERE account_type = ? AND account_state = 'OPEN'ORDER BY creation_time";
    public static final String GET_ACCOUNTS_FOR_TYPE_CURRENT_DAY = "SELECT sales_account.* FROM sales_account WHERE account_type = ? AND account_state = 'OPEN'AND FK_finance_trading_day = ? ORDER BY creation_time";
    public static final String GET_CUSTOMERS_LAST_ACCOUNT = "SELECT DISTINCT sales_account.* FROM sales_account, sales_item WHERE sales_item.FK_sales_account = sales_account.ID AND sales_item.FK_sales_customer = ? ORDER BY ID DESC LIMIT 1";
    public static final String GET_ACCOUNT_FOR_SHIFT = "SELECT sales_account.* FROM sales_account WHERE FK_Finance_shift = ?";
    public static final String HAS_ACTIVE_ITEMS = "SELECT sum(sales_item_quantity.quantity) as total FROM sales_item, sales_item_quantity WHERE sales_item_quantity.FK_sales_item = sales_item.ID AND sales_item.FK_sales_account = ? HAVING total > 0 ";
    public static final String GET_COURSES = "SELECT config_course.name FROM config_course ORDER BY config_course.ID";
    public static final String CLOSE_STALE_ACCOUNTS = "UPDATE sales_account SET account_state ='CLOSED',closed_time = NOW(), mod_time = NOW() WHERE account_state = 'open' AND creation_time <= NOW() - INTERVAL 1 DAY";

    public static Price getCostOfDeletedItems(Shift shift) {
        String query = AccountQueries.getItemStateQuery(new String[]{"DELETED", "DELETED_WASTED"}) + " AND sales_account.FK_finance_shift = ? ";
        PriceReport report = PersistenceManager.getObject(PriceReport.class, query, shift.getID());
        if (report != null) {
            return report.getPrice();
        }
        return Price.ZERO;
    }

    public static Price getCostOfRefundedItems(Shift shift) {
        String query = AccountQueries.getItemStateQuery(new String[]{"REFUNDED", "REFUNDED_WASTED"}) + " AND sales_account.FK_finance_shift = ? ";
        PriceReport report = PersistenceManager.getObject(PriceReport.class, query, shift.getID());
        if (report != null) {
            return report.getPrice();
        }
        return Price.ZERO;
    }

    public static Price getCostOfRefundedItemsFromOtherShifts(Shift shift) {
        String query = AccountQueries.getItemStateQuery(new String[]{"REFUNDED", "REFUNDED_WASTED"}) + " AND sales_item_quantity.FK_finance_shift = ?  AND sales_account.FK_finance_shift != ?";
        PriceReport report = PersistenceManager.getObject(PriceReport.class, query, new Object[]{shift.getID(), shift.getID()});
        if (report != null) {
            return report.getPrice();
        }
        return Price.ZERO_DOLLAR;
    }

    public static int getTotalNumberOfNoSales(Shift shift) {
        int count = 0;
        ObjectQuery query = Query.select(EventLogRecord.class).equals(EventLogRecord.Properties.TYPE, "No Sale").equals(EventLogRecord.Properties.SHIFT, shift.getID());
        List<EventLogRecord> result = PersistenceManager.getObjectList(EventLogRecord.class, query.toString(), new Object[0]);
        if (result != null) {
            count = result.size();
        }
        return count;
    }

    private static String getItemStateQuery(String[] itemStates) {
        StringBuilder states = new StringBuilder("( '");
        for (int i = 0; i < itemStates.length; ++i) {
            if (i != 0) {
                states.append("' , '");
            }
            states.append(itemStates[i]);
        }
        states.append("')");
        String query = "SELECT 1 as 'ID', SUM(sales_component.unit_price  * sales_item_quantity.quantity * -1) AS price FROM sales_component INNER JOIN sales_item on sales_component.FK_sales_item = sales_item.ID INNER JOIN sales_item_quantity on sales_item.ID = sales_item_quantity.FK_sales_item INNER JOIN sales_account ON sales_account.ID = sales_item.FK_sales_account WHERE sales_item_quantity.item_state IN " + states;
        return query;
    }

    public static int getTotalNumberOfPatrons(Shift shift) {
        Object[][] result;
        ObjectQuery query = Query.sum(Account.Properties.NUM_PATRONS);
        query.equals(Account.Properties.SHIFT, shift);
        if (!DeterminePatrons.Item.equals((Object)SystemProperty.getInstance().getDeterminePatrons())) {
            query.whereFunction("sales_account.account_type = 'TABLE'");
        }
        if ((result = PersistenceManager.getPersistenceDelegate().executeQuery(query.toString(), null)) != null && result[0] != null && result[0][0] != null) {
            try {
                return (int)Double.parseDouble(result[0][0].toString());
            }
            catch (NumberFormatException ex) {
                OrderMate.LOG.error("Number format exception calculating number of covers", (Throwable)ex);
            }
        }
        return 0;
    }

    public static final Account getLastAccountForCustomer(Account account, Customer theCustomer) {
        ObjectQuery query = Query.select(account.getClass()).whereFunction("sales_account.acc_class = '" + account.getAccountType().getDiscriminator() + "' AND sales_account.saved_total > 0").equals(Account.Properties.CUSTOMER, theCustomer).limit(1).orderByDesc(Account.Properties.CREATION_DATE_TIME);
        return PersistenceManager.getObject(Account.class, query.toString());
    }

    public static final Account getLastAccountOfType(AccountType accountType) {
        ObjectQuery query = Query.select(Account.class).equals(Account.Properties.ACCOUNT_TYPE, accountType).orderByDesc(Account.Properties.CREATION_DATE_TIME).limit(1);
        return PersistenceManager.getObject(Account.class, query.toString());
    }

    public static GiftVoucherTransaction getLastRedeemVoucherTxn(Account account) {
        ObjectQuery query = Query.select(GiftVoucherTransaction.class).equals(GiftVoucherTransaction.Properties.ACCOUNT, account).lessThan(GiftVoucherTransaction.Properties.AMOUNT, 0.0).active(GiftVoucherTransaction.class).not().isNull(GiftVoucherTransaction.Properties.AUTH_ID).orderBy(GiftVoucherTransaction.Properties.ID, true).limit(1);
        GiftVoucherTransaction lastRedeemVoucherTxn = PersistenceManager.getObject(GiftVoucherTransaction.class, query.toString());
        return lastRedeemVoucherTxn;
    }

    public static final Account getOnlineOrderAccountForThirdParty(OrderMateSale sale) {
        if (sale.getID() != null) {
            return PersistenceManager.getByID(sale.getID(), Account.class);
        }
        return AccountQueries.getOnlineOrderAccountForThirdParty(sale.getExtOrderID(), sale.getExtSourceName());
    }

    public static final Account getOnlineOrderAccountForThirdParty(String extId, String source) {
        TradingDay day = TradingDay.getCurrentTradingDay();
        TradingDay previousDay = day.getPreviousTradingDay();
        ObjectQuery query = Query.select(Account.class).equals(Account.Properties.EXT_ORDER_ID, extId).equals(Account.Properties.SOURCE, source).group().equals(Account.Properties.TRADING_DAY, day);
        if (previousDay != null) {
            query.or().equals(Account.Properties.TRADING_DAY, previousDay);
        }
        query.endGroup().limit(1);
        return PersistenceManager.getObject(Account.class, query.toString());
    }

    public static List<Account> getAccountsWithDiscounts(Shift shift) {
        List<Account> accounts;
        ObjectQuery query = Query.select(Account.class).distinct().linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesPriceAdjustmentUsage.Properties.SALES_COMPONENT).equals(Account.Properties.SHIFT, shift).orderBy(Account.Properties.ID);
        if (SystemProperty.getInstance().isCombosAsDiscount()) {
            LinkedHashSet<Account> accountSet = new LinkedHashSet<Account>(PersistenceManager.getObjectList(Account.class, query.toString()));
            query = Query.select(Account.class).distinct().linkUsing(SalesCombo.Properties.ACCOUNT).whereFunction("sales_item.type NOT IN ('SalesItem','SimpleCombo', 'SalesAdjustmentCombo')").equals(Account.Properties.SHIFT, shift).orderBy(Account.Properties.ID);
            accountSet.addAll(PersistenceManager.getObjectList(Account.class, query.toString()));
            accounts = new ArrayList<Account>(accountSet);
        } else {
            accounts = PersistenceManager.getObjectList(Account.class, query.toString());
        }
        return accounts;
    }

    public static List<FinanceTransaction> getAllAccountFinanceTransactions(Account account) {
        return PersistenceManager.getObjectList(FinanceTransaction.class, Query.select(FinanceTransaction.class).equals(FinanceTransaction.Properties.ACCOUNT, account).toString());
    }

    public static Account getAccountCreatedAfter(Date creationAfterDate) {
        return PersistenceManager.getObject(Account.class, Query.select(Account.class).greaterThanOrEqual(Account.Properties.CREATION_DATE_TIME, creationAfterDate, SQLDateType.DATE).orderByDesc(Account.Properties.CREATION_DATE_TIME).limit(1).toString(), null);
    }

    public static List<Account> getClosedAccounts(TradingDay tradingDay) {
        return PersistenceManager.getObjectList(Account.class, Query.select(Account.class).equals(Account.Properties.TRADING_DAY, tradingDay).equals(Account.Properties.ACCOUNT_STATE, CLOSED).orderBy(Account.Properties.CREATION_DATE_TIME).toString(), null);
    }

    public static List<Account> getAllAccounts(TradingDay tradingDay) {
        ObjectQuery query = Query.select(Account.class).equals(Account.Properties.TRADING_DAY, tradingDay).orderBy(Account.Properties.CREATION_DATE_TIME);
        return PersistenceManager.getObjectList(Account.class, query.toString(), null);
    }

    public static List<SalesItemQuantity> getRefundQuantities(Account account) {
        ObjectQuery query = Query.select(SalesItemQuantity.class).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM, SalesItem.Properties.ID).whereFunction("sales_item_quantity.item_state IN ('REFUNDED', 'REFUNDED_WASTED')").equals(SalesLineItem.Properties.ACCOUNT, account).orderBy(SalesItemQuantity.Properties.ID);
        return PersistenceManager.getObjectList(SalesItemQuantity.class, query.toString());
    }

    public static List<Account> getClosedAccounts(Date startDT, Date enbDT) {
        return PersistenceManager.getObjectList(Account.class, Query.select(Account.class).greaterThanOrEqual(Account.Properties.CREATION_DATE_TIME, startDT, SQLDateType.DATE).lessThan(Account.Properties.CREATION_DATE_TIME, enbDT, SQLDateType.DATE).equals(Account.Properties.ACCOUNT_STATE, CLOSED).orderBy(Account.Properties.CREATION_DATE_TIME).toString(), null);
    }

    public static Account getBarTabWithName(String tabName) {
        return PersistenceManager.getObject(Account.class, Query.select(Account.class).equals(Account.Properties.ACCOUNT_TYPE, AccountType.barTabType).equals(BarTabAccount.Properties.TAB_NAME, tabName).equals(Account.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).limit(1).toString());
    }

    public static void closeStaleAccounts() {
        PersistenceManager.getPersistenceDelegate().executeUpdate(CLOSE_STALE_ACCOUNTS, null);
    }
}

