/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.sales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.reference.QueryReference;
import ordermate.database.queries.DomainQueries;
import ordermate.database.sales.CustomerCategory;

public class CustomerCategoryQueries
implements DomainQueries {
    public static final ObjectQuery SELECT_DEFAULT_CATEGORY = Query.select(CustomerCategory.class).equals(CustomerCategory.Properties.IS_DEFAULT, 1.0);
    public static final Reference<CustomerCategory> defaultCustomerCategory = new LocalCachedReference<CustomerCategory>(new QueryReference<CustomerCategory>(CustomerCategory.class, SELECT_DEFAULT_CATEGORY));

    public static final CustomerCategory getDefaultCustomerCategory() {
        return defaultCustomerCategory.get();
    }

    public static final CustomerCategory getCategory(String name) {
        ObjectQuery query = Query.select(CustomerCategory.class).equals(CustomerCategory.Properties.LABEL, name);
        return PersistenceManager.getObject(CustomerCategory.class, query.toString());
    }

    public static final CustomerCategory getCategoryById(long id) {
        return PersistenceManager.getByID(id, CustomerCategory.class);
    }

    public static final CustomerCategory getVipCategory() {
        return CustomerCategoryQueries.getCategory("VIP");
    }
}

