/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.sales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.sql.SQL;
import ordermate.database.queries.DomainQueries;
import ordermate.database.sales.Customer;

public class CustomerQueries
implements DomainQueries {
    public static final String GET_RESERVATION_CUSTOMER = "SELECT sales_customer.* FROM sales_customer, sales_reservation  WHERE " + SQL.join("sales_reservation", "sales_customer") + " AND sales_customer.system_state = 'ACTIVE' AND sales_reservation.ID = ? ";
    public static final String GET_CUSTOMER_BY_CARD = "SELECT sales_customer.* FROM sales_customer WHERE sales_customer.system_state = 'ACTIVE' AND card_id = ?";
    public static final String GET_SALES_ITEM_CUSTOMER = "SELECT\tsales_customer.* FROM sales_item, sales_customer  WHERE " + SQL.join("sales_item", "sales_customer") + " AND sales_customer.system_state = 'ACTIVE' AND sales_item.ID = ?";
    public static final String SEARCH_CUSTOMER_ALL_CUSTOMER = "SELECT sales_customer.* FROM sales_customer WHERE system_state = 'ACTIVE' ORDER BY primary_phone, secondary_phone LIMIT 100";
    public static final String SEARCH_CUSTOMER_BY_PHONE = "SELECT sales_customer.* FROM sales_customer WHERE (primary_phone LIKE ? OR secondary_phone LIKE ?) AND system_state = 'ACTIVE' ORDER BY primary_phone, secondary_phone LIMIT 100";
    public static final String SEARCH_CUSTOMER_BY_ID = "SELECT sales_customer.* FROM sales_customer WHERE ID LIKE ? AND system_state = 'ACTIVE' ORDER BY ID LIMIT 20";
    @Deprecated
    public static final String GET_ALL_CUSTOMERS = "SELECT sales_customer.* FROM sales_customer WHERE system_state = 'ACTIVE' ORDER BY last_name, first_name ";
    public static final String GET_ALL_CUSTOMERS_FOR_EXPORT = "SELECT 0 AS Spending, config_customer_group.Name, sales_customer.title, sales_customer.first_name, sales_customer.last_name, sales_customer.occupation, sales_customer.company, sales_customer.primary_phone, sales_customer.secondary_phone, sales_customer.email, DAYOFMONTH(sales_customer.dob) AS Dob_Day, MONTH(sales_customer.dob) AS Dob_Month, YEAR(sales_customer.dob) AS Dob_Year, sales_customer.house_number, sales_customer.street_name, sales_customer.street_type, sales_customer.suburb, sales_customer.postcode, sales_customer.state, sales_customer.street_directory_ref, sales_customer_points.total_points, sales_customer.card_id, sales_customer.comments, sales_customer.ID FROM sales_customer \tLEFT JOIN config_customer_group \t\tON sales_customer.FK_config_customer_group = config_customer_group.ID  LEFT JOIN sales_customer_points ON sales_customer_points.fk_sales_customer = sales_customer.id WHERE sales_customer.system_state = 'ACTIVE' ORDER BY sales_customer.last_name, \tsales_customer.first_name, \tsales_customer.ID ";
    public static final String GET_CUSTOMERS_WITH_SPENDINGS_FOR_EXPORT = "SELECT sales_customer.ID, SUM(sales_component.unit_price * sales_item_quantity.Quantity) AS Spending, sales_customer.last_name, sales_customer.first_name FROM sales_customer, sales_item, sales_component, sales_item_quantity WHERE sales_item.FK_sales_customer = sales_customer.ID AND sales_item_quantity.FK_sales_item = sales_item.ID AND sales_component.FK_sales_item = sales_item.ID AND sales_customer.system_state = 'ACTIVE' GROUP BY sales_customer.ID ORDER BY sales_customer.last_name, sales_customer.first_name, sales_customer.ID ";
    public static final String GET_SOME_CUSTOMERS = "SELECT sales_customer.* FROM sales_customer WHERE system_state = 'ACTIVE' ORDER BY sales_customer.first_name, sales_customer.last_name LIMIT ?";

    public static final ObjectQuery getByEmail(String email) {
        return Query.select(Customer.class).active(Customer.class).equals(Customer.Properties.E_MAIL, email);
    }

    public static ObjectQuery getByName(String firstName, String surname) {
        if (firstName == null) {
            return Query.select(Customer.class).wherePropertyLike(Customer.Properties.LAST_NAME, surname);
        }
        if (surname == null) {
            return Query.select(Customer.class).wherePropertyLike(Customer.Properties.FIRST_NAME, firstName);
        }
        return Query.select(Customer.class).wherePropertyLike(Customer.Properties.FIRST_NAME, firstName).wherePropertyLike(Customer.Properties.LAST_NAME, surname);
    }

    public static Customer getByExtWebId(String extWebId) {
        ObjectQuery query = Query.select(Customer.class).equals(Customer.Properties.EXT_WEB_ID, extWebId);
        return PersistenceManager.getObject(Customer.class, query.toString());
    }
}

