/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.sales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import java.util.Date;
import ordermate.database.finance.Shift;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.DomainQueries;
import ordermate.database.sales.Account;
import ordermate.database.sales.Delivery;
import ordermate.database.users.User;

public class DeliveryQueries
implements DomainQueries {
    public static final String QUERY_GET_DELIVERY = "SELECT * FROM sales_delivery WHERE FK_config_user_driver = ? AND delivery_state = ?AND system_state = 'ACTIVE'";
    public static final String QUERY_GET_DELIVERIES_FOR_SHIFT = "SELECT DISTINCT sales_delivery.* FROM sales_delivery, sales_account WHERE sales_delivery.ID = sales_account.FK_sales_delivery AND system_state = 'ACTIVE' AND sales_account.FK_finance_shift = ? AND sales_delivery.delivery_state = ?";

    public static ObjectQuery getDeliveriesForShift(String deliveryState, Shift shift) {
        ObjectQuery query = DeliveryQueries.getDeliveriesForShift(shift);
        query.equals(Delivery.Properties.STATUS, deliveryState);
        return query;
    }

    public static ObjectQuery getDeliveriesForShift(Shift shift) {
        return Query.select(Delivery.class).active(Delivery.class).equals(Account.Properties.SHIFT, shift).linkUsing(Delivery.Properties.ACCOUNTS);
    }

    public static ObjectQuery getDeliveriesForShift(User driver, Shift startShift, Shift endShift) {
        ObjectQuery query = DeliveryQueries.getDeliveriesWithinShifts(startShift, endShift);
        return DeliveryQueries.addDriverFilter(query, driver);
    }

    public static ObjectQuery getDeliveriesWithinShifts(Shift startShift, Shift endShift) {
        return Query.select(Delivery.class).active(Delivery.class).linkUsing(Delivery.Properties.ACCOUNTS).wherePropertyBetween(Account.Properties.SHIFT, startShift, endShift);
    }

    private static ObjectQuery addDriverFilter(ObjectQuery query, User driver) {
        query.equals(Delivery.Properties.DRIVER, driver);
        return query;
    }

    public static ObjectQuery getDeliveriesForTradingDay(User driver, TradingDay start, TradingDay end) {
        return DeliveryQueries.addDriverFilter(DeliveryQueries.getDeliveriesWithinTradingDays(start, end), driver);
    }

    public static ObjectQuery getDeliveriesWithinTradingDays(TradingDay start, TradingDay end) {
        Date startDate = start.getDate();
        Date endDate = end.getCloseDate();
        if (endDate == null) {
            endDate = new Date();
        }
        return Query.select(Delivery.class).active(Delivery.class).wherePropertyBetween(Delivery.Properties.TIME_CREATED, startDate, endDate, SQLDateType.TIMESTAMP);
    }
}

