/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.sales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.util.Calendar;
import java.util.List;
import ordermate.database.finance.Shift;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.DomainQueries;
import ordermate.database.queries.sales.DeliveryState;
import ordermate.database.reports.general.NumberReport;
import ordermate.database.reports.general.PriceReport;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.Delivery;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.users.User;

public abstract class PhoneAccountQueries
implements DomainQueries {
    public static final String GET_DELIVERY_ACCOUNTS = "SELECT sales_account.* FROM sales_account WHERE sales_account.FK_sales_delivery = ? ORDER BY creation_time";
    public static final ObjectQuery userDeliveryAccounts = Query.select(Account.class).linkUsing(PhoneAccount.Properties.DELIVERY).equalsParam(Delivery.Properties.DRIVER);
    public static final String GET_USER_DELIVERY_ACCOUNT_COUNT = "SELECT count(*) as value FROM sales_account, sales_delivery WHERE sales_delivery.FK_config_user_driver = ? AND sales_account.FK_sales_delivery = sales_delivery.ID AND sales_account.delivered = ? AND sales_delivery.delivery_state = ? AND sales_delivery.system_state = 'ACTIVE' ";
    public static final String GET_USER_DELIVERY_ACCOUNTS = "SELECT sales_account.* FROM sales_account, sales_delivery WHERE sales_delivery.FK_config_user_driver = ? AND sales_account.FK_sales_delivery = sales_delivery.ID AND sales_account.delivered = ? AND sales_delivery.delivery_state = ? AND sales_delivery.system_state = 'ACTIVE' ";
    private static final ObjectQuery unassignedDelivery = Query.select(Account.class).isNull(PhoneAccount.Properties.DELIVERY).equals(PhoneAccount.Properties.DELIVERED, false).equals(PhoneAccount.Properties.DELIVERABLE, "1").orderBy(PhoneAccount.Properties.CREATION_DATE_TIME);
    public static final String GET_UNASSIGNED_DELIVERY_ACCOUNTS = unassignedDelivery.copy().toString();
    public static final String GET_CURRENT_PICKUP_ACCOUNTS = "SELECT sales_account.* FROM sales_account WHERE sales_account.account_type = 'PHONE' AND sales_account.deliverable = 0 AND sales_account.account_state = 'OPEN'";

    public static ObjectQuery getUnassignedDeliveryAccountsForType(AccountType type) {
        Calendar cal = Calendar.getInstance();
        DateTimeUtils.clearTimePart(cal);
        cal.add(5, -90);
        return unassignedDelivery.copy().equals(PhoneAccount.Properties.ACCOUNT_TYPE, type).greaterThan(PhoneAccount.Properties.CREATION_DATE_TIME, cal.getTime(), SQLDateType.TIMESTAMP);
    }

    public static long getUserDeliveryAccountCount(User driver) {
        if (driver == null) {
            return 0L;
        }
        NumberReport report = PersistenceManager.getObject(NumberReport.class, GET_USER_DELIVERY_ACCOUNT_COUNT, new Object[]{driver.getID(), true, DeliveryState.RETURNED.toString()});
        return report.getValue();
    }

    public static List<PhoneAccount> getUserDeliveryAccounts(User driver, boolean delivered, DeliveryState state) {
        if (driver == null) {
            throw new IllegalArgumentException("Driver not specified.");
        }
        return PersistenceManager.getObjectList(Account.class, GET_USER_DELIVERY_ACCOUNTS, new Object[]{driver.getID(), delivered, state.toString()});
    }

    public static List<PhoneAccount> getReturnedDeliveryAccounts(User driver) {
        return PhoneAccountQueries.getUserDeliveryAccounts(driver, true, DeliveryState.RETURNED);
    }

    public static List<PhoneAccount> getUndeliveredAccounts(User driver) {
        return PhoneAccountQueries.getUserDeliveryAccounts(driver, false, DeliveryState.ASSIGNED);
    }

    public static class DeliveryFees {
        private static final String query_prefix = "SELECT 1 as 'ID', SUM(saved_total_value) as price FROM sales_account INNER JOIN sales_item ON sales_item.fk_sales_account = sales_account.ID INNER JOIN sales_component ON fk_sales_item = sales_item.ID INNER JOIN sales_price_adjustment_usage \tON sales_price_adjustment_usage.fk_sales_component = sales_component.ID INNER JOIN sales_price_adjustment ON sales_price_adjustment.ID = sales_price_adjustment_usage.fk_sales_price_adjustment INNER JOIN inventory_price_adjustment ON fk_inventory_price_adjustment = inventory_price_adjustment.ID WHERE inventory_price_adjustment.TYPE = 'DELIVERY_SURCHARGE'";
        private static final String restrict_by_shift = " AND sales_account.fk_finance_shift BETWEEN ? AND ? ";
        private static final String restrict_by_trading_day = " AND sales_account.fk_finance_trading_day BETWEEN ? AND ? ";
        private static final String QUERY_BY_SHIFT_RANGE = "SELECT 1 as 'ID', SUM(saved_total_value) as price FROM sales_account INNER JOIN sales_item ON sales_item.fk_sales_account = sales_account.ID INNER JOIN sales_component ON fk_sales_item = sales_item.ID INNER JOIN sales_price_adjustment_usage \tON sales_price_adjustment_usage.fk_sales_component = sales_component.ID INNER JOIN sales_price_adjustment ON sales_price_adjustment.ID = sales_price_adjustment_usage.fk_sales_price_adjustment INNER JOIN inventory_price_adjustment ON fk_inventory_price_adjustment = inventory_price_adjustment.ID WHERE inventory_price_adjustment.TYPE = 'DELIVERY_SURCHARGE' AND sales_account.fk_finance_shift BETWEEN ? AND ? ";
        private static final String QUERY_BY_TRADING_DAY = "SELECT 1 as 'ID', SUM(saved_total_value) as price FROM sales_account INNER JOIN sales_item ON sales_item.fk_sales_account = sales_account.ID INNER JOIN sales_component ON fk_sales_item = sales_item.ID INNER JOIN sales_price_adjustment_usage \tON sales_price_adjustment_usage.fk_sales_component = sales_component.ID INNER JOIN sales_price_adjustment ON sales_price_adjustment.ID = sales_price_adjustment_usage.fk_sales_price_adjustment INNER JOIN inventory_price_adjustment ON fk_inventory_price_adjustment = inventory_price_adjustment.ID WHERE inventory_price_adjustment.TYPE = 'DELIVERY_SURCHARGE' AND sales_account.fk_finance_trading_day BETWEEN ? AND ? ";

        public static Price getTotalDeliveryFees(Shift start, Shift finish) {
            Object[] params = new Object[]{start.getID(), finish.getID()};
            return DeliveryFees.getFeeFromQuery(QUERY_BY_SHIFT_RANGE, params);
        }

        public static Price getTotalDeliveryFees(Shift shift) {
            return DeliveryFees.getTotalDeliveryFees(shift, shift);
        }

        public static Price getTotalDeliveryFees(TradingDay start, TradingDay finish) {
            Long startID = null;
            Long finishID = null;
            if (start != null) {
                startID = start.getID();
            }
            if (finish != null) {
                finishID = finish.getID();
            }
            Object[] params = new Object[]{startID, finishID};
            return DeliveryFees.getFeeFromQuery(QUERY_BY_TRADING_DAY, params);
        }

        public static Price getTotalDeliveryFees(TradingDay day) {
            return DeliveryFees.getTotalDeliveryFees(day, day);
        }

        private static Price getFeeFromQuery(String query, Object[] params) {
            PriceReport report = PersistenceManager.getObject(PriceReport.class, query, params);
            if (report != null) {
                return report.getPrice().multiply(-1);
            }
            return Price.ZERO;
        }
    }
}

