/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.sales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.SQLPeriodFunction;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.DomainQueries;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.reports.dynamicjasper.PeriodReportAdapter;

public class SalesHistoryQueries
implements DomainQueries {
    public static ObjectQuery salesByPeriodQuery(PeriodReportAdapter period) {
        ObjectQuery query = SalesHistoryQueries.salesByPeriodBaseQuery();
        SalesHistoryQueries.addGroupBy(query, period);
        return query;
    }

    public static ObjectQuery salesByPeriodBaseQuery() {
        ObjectQuery query = new ObjectQuery().select(Account.Properties.ID, "ID").max(TradingDay.Properties.DATE, "last_sale").sumMultiplication(SalesItemQuantity.Properties.QUANTITY, SalesComponent.Properties.SAVED_UNIT_PRICE, "sales_value").linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesLineItem.Properties.ACCOUNT).linkUsing(Account.Properties.TRADING_DAY);
        return query;
    }

    public static void addGroupBy(ObjectQuery query, PeriodReportAdapter period) {
        if (period == PeriodReportAdapter.DAILY) {
            query.groupBy(TradingDay.Properties.DATE);
        } else {
            query.groupBy(SQLPeriodFunction.YEAR, TradingDay.Properties.DATE);
            if (period != PeriodReportAdapter.YEAR) {
                query.groupBy(SalesHistoryQueries.getTradingDayGroupByFunction(period), TradingDay.Properties.DATE);
            }
        }
    }

    public static SQLPeriodFunction getTradingDayGroupByFunction(PeriodReportAdapter period) {
        if (period == PeriodReportAdapter.MONTHLY) {
            return SQLPeriodFunction.MONTH;
        }
        if (period == PeriodReportAdapter.QUARTER) {
            return SQLPeriodFunction.QUARTER;
        }
        if (period == PeriodReportAdapter.WEEK_ENDING) {
            return SQLPeriodFunction.WEEK;
        }
        if (period == PeriodReportAdapter.DAILY) {
            return SQLPeriodFunction.DAY;
        }
        if (period == PeriodReportAdapter.YEAR) {
            return SQLPeriodFunction.YEAR;
        }
        throw new IllegalArgumentException("Unsupported PeriodReportAdapter. Please specify the grouping function for " + period);
    }
}

