/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.sales;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import java.util.Collection;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.DomainQueries;
import ordermate.database.queries.sales.StaffReportColumn;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;

public class StaffItemReportQueries
implements DomainQueries {
    public static ObjectQuery staffItemQuery() {
        return Query.select(SalesLineItem.Properties.ACCOUNT, StaffReportColumn.ACCOUNT.col).select(SalesLineItem.Properties.ID, StaffReportColumn.LINE_ITEM.col).select(InventoryItem.Properties.LABEL, StaffReportColumn.NAME.col).select(InventoryItemSize.Properties.LABEL, StaffReportColumn.SIZE.col).select(InventoryItemPortion.Properties.LABEL, StaffReportColumn.PORTION.col).select(SalesComponent.Properties.SAVED_UNIT_PRICE, StaffReportColumn.UNIT_PRICE.col).multiplication(SalesComponent.Properties.SAVED_UNIT_PRICE, SalesItemQuantity.Properties.QUANTITY, StaffReportColumn.TOTAL.col).select(SalesItemQuantity.Properties.QUANTITY, StaffReportColumn.QUANTITY.col).select(User.Properties.FIRST_NAME, StaffReportColumn.FIRSTNAME.col).select(User.Properties.LAST_NAME, StaffReportColumn.LASTNAME.col).select(Account.Properties.CREATION_DATE_TIME, StaffReportColumn.CREATION_TIME.col).select(Account.Properties.TRADING_DAY, StaffReportColumn.TRADING_DAY.col).linkUsing(InventoryItemUnit.Properties.ITEM).linkUsing(SalesComponent.Properties.UNIT).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(InventoryItemUnit.Properties.SIZE).linkUsing(InventoryItemUnit.Properties.PORTION).linkUsing(SalesItemQuantity.Properties.USER).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM);
    }

    public static ObjectQuery staffItemSummaryQuery() {
        return StaffItemReportQueries.staffItemQuery().clearSelect().select(InventoryItemUnit.Properties.ID, StaffReportColumn.REF.col).select(InventoryItem.Properties.LABEL, StaffReportColumn.NAME.col).select(InventoryItemSize.Properties.LABEL, StaffReportColumn.SIZE.col).select(InventoryItemPortion.Properties.LABEL, StaffReportColumn.PORTION.col).select(User.Properties.FIRST_NAME, StaffReportColumn.FIRSTNAME.col).select(User.Properties.LAST_NAME, StaffReportColumn.LASTNAME.col).sumMultiplication(SalesComponent.Properties.SAVED_UNIT_PRICE, SalesItemQuantity.Properties.QUANTITY, StaffReportColumn.TOTAL.col).sumMultiplication(SalesItemQuantity.Properties.QUANTITY, SalesComponent.Properties.PORTION, StaffReportColumn.QUANTITY.col).groupBy(InventoryItemUnit.Properties.ID).groupBy(User.Properties.ID).orderBy(InventoryItem.Properties.LABEL).orderBy(InventoryItemSize.Properties.LABEL).orderBy(InventoryItemPortion.Properties.LABEL).orderBy(User.Properties.FIRST_NAME).orderBy(User.Properties.LAST_NAME);
    }

    public static ObjectQuery deletedItemsSummaryQuery() {
        return Query.select(Account.Properties.ID, StaffReportColumn.ACCOUNT.col).select(InventoryItemUnit.Properties.ID, StaffReportColumn.REF.col).select(Account.Properties.CREATION_DATE_TIME, StaffReportColumn.CREATION_TIME.col).selectFunc("(select modification_time from sales_item_quantity iq join config_user du on iq.FK_config_user=du.ID  where (iq.item_state='ACTIVE') and (iq.FK_sales_item=sales_item_quantity.FK_sales_item)  order by modification_time limit 1) ordered_time").selectFunc("(select concat(config_user.FirstName,' ',config_user.Surname) from sales_item_quantity iq join config_user on iq.FK_config_user=config_user.ID  where (iq.item_state='ACTIVE') and (iq.FK_sales_item=sales_item_quantity.FK_sales_item) order by modification_time desc limit 1) ordered_user").selectFunc("sales_item_quantity.modification_time as deleted_time").selectFunc("concat(config_user.FirstName,' ', config_user.Surname) 'deleted_user'").select(InventoryItem.Properties.LABEL, StaffReportColumn.NAME.col).select(InventoryItemSize.Properties.LABEL, StaffReportColumn.SIZE.col).select(User.Properties.FIRST_NAME, StaffReportColumn.FIRSTNAME.col).select(User.Properties.LAST_NAME, StaffReportColumn.LASTNAME.col).select(InventoryItemPortion.Properties.LABEL, StaffReportColumn.PORTION.col).selectFunc("SUM(sales_item_quantity.quantity) as quantity").selectFunc("SUM(sales_component.unit_price * sales_item_quantity.quantity) as total").linkUsing(InventoryItemUnit.Properties.ITEM).linkUsing(SalesComponent.Properties.UNIT).linkUsing(SalesComponent.Properties.SALES_ITEM).linkUsing(SalesItem.Properties.ACCOUNT).linkUsing(InventoryItemUnit.Properties.SIZE).linkUsing(InventoryItemUnit.Properties.PORTION).linkUsing("sales_item_quantity", "FK_config_user", "config_user", "ID").joinFunction("", SalesItemQuantity.class).from("sales_item_quantity", "sales_item_quantity").whereFunction("(sales_item_quantity.item_state = 'DELETED' OR sales_item_quantity.item_state = 'DELETED_WASTED')").whereFunction("(sales_item_quantity.FK_sales_item = sales_item.ID)").groupBy(Account.Properties.TRADING_DAY).groupBy(SalesItemQuantity.Properties.SALES_LINE_ITEM).groupBy("sales_item_quantity.FK_sales_item").groupBy(User.Properties.ID).orderBy("sales_item_quantity.creation_time", true).orderBy(User.Properties.FIRST_NAME).orderBy(User.Properties.LAST_NAME).orderBy(Account.Properties.CREATION_DATE_TIME).orderBy(InventoryItem.Properties.LABEL).orderBy(InventoryItemSize.Properties.LABEL).orderBy(InventoryItemPortion.Properties.LABEL);
    }

    public static ObjectQuery deletionsSummaryQuery() {
        return StaffItemReportQueries.staffItemQuery().clearSelect().group().equals(SalesItemQuantity.Properties.ITEM_STATE, "DELETED").or().equals(SalesItemQuantity.Properties.ITEM_STATE, "DELETED_WASTED").endGroup().select(InventoryItemUnit.Properties.ID, StaffReportColumn.REF.col).select(Account.Properties.CREATION_DATE_TIME, StaffReportColumn.CREATION_TIME.col).select(InventoryItem.Properties.LABEL, StaffReportColumn.NAME.col).select(InventoryItemSize.Properties.LABEL, StaffReportColumn.SIZE.col).select(InventoryItemPortion.Properties.LABEL, StaffReportColumn.PORTION.col).select(User.Properties.FIRST_NAME, StaffReportColumn.FIRSTNAME.col).select(User.Properties.LAST_NAME, StaffReportColumn.LASTNAME.col).sumMultiplication(SalesComponent.Properties.SAVED_UNIT_PRICE, SalesItemQuantity.Properties.QUANTITY, StaffReportColumn.TOTAL.col).sum(SalesItemQuantity.Properties.QUANTITY, StaffReportColumn.QUANTITY.col).groupBy(Account.Properties.TRADING_DAY).groupBy(SalesItemQuantity.Properties.SALES_LINE_ITEM).groupBy(User.Properties.ID).orderBy(User.Properties.FIRST_NAME).orderBy(User.Properties.LAST_NAME).orderBy(Account.Properties.CREATION_DATE_TIME).orderBy(InventoryItem.Properties.LABEL).orderBy(InventoryItemSize.Properties.LABEL).orderBy(InventoryItemPortion.Properties.LABEL);
    }

    public static ObjectQuery firstAndLastSaleTimesForTradingDays(Collection<TradingDay> days) {
        ObjectQuery qry = Query.select(SalesItemQuantity.Properties.TRADING_DAY).min(SalesItemQuantity.Properties.CREATION_TIME, "min_creation_time").max(SalesItemQuantity.Properties.CREATION_TIME, "max_creation_time");
        if (days != null && !days.isEmpty()) {
            qry.wherePropertyIn(Account.Properties.TRADING_DAY, days);
        }
        qry.linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM, SalesLineItem.Properties.ID);
        qry.linkUsing(Account.Properties.ID, SalesLineItem.Properties.ACCOUNT);
        qry.groupBy(Account.Properties.TRADING_DAY);
        return qry;
    }
}

