/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.sales.reservation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import ordermate.database.queries.DomainQueries;
import ordermate.database.sales.Account;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.sales.reservation.ReservationAccount;
import ordermate.database.sales.reservation.ReservationAccountState;

public class ReservationAccountQueries
implements DomainQueries {
    public static List<Account> getReservationLinkedAccounts(Reservation acc) {
        if (acc == null) {
            throw new IllegalArgumentException("Account cannot be null!");
        }
        ObjectQuery query = Query.select(Account.class);
        query.equals(ReservationAccount.Properties.ACCOUNT, acc);
        query.wherePropertyIn(ReservationAccount.Properties.ACCOUNT_STATE, new ArrayList<ReservationAccountState>(Arrays.asList(ReservationAccountState.OPEN, ReservationAccountState.CLOSED)));
        return PersistenceManager.getObjectList(Account.class, query.toString());
    }

    public static Reservation getReservation(Account acc) {
        if (acc == null) {
            throw new IllegalArgumentException("Account cannot be null!");
        }
        ObjectQuery query = Query.select(ReservationAccount.class);
        query.equals(ReservationAccount.Properties.ACCOUNT_STATE, (Object)ReservationAccountState.OPEN);
        query.equals(ReservationAccount.Properties.ACCOUNT, acc);
        ReservationAccount resAcc = PersistenceManager.getObject(ReservationAccount.class, query.toString());
        return resAcc != null ? resAcc.getReservation() : null;
    }
}

