/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.sales.reservation;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Date;
import ordermate.database.queries.DomainQueries;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.tables.LogicalTable;

public class ReservationQueries
implements DomainQueries {
    public static ObjectQuery getQueryForExternalReservations(Date minDate, Date maxDate) {
        ObjectQuery query = new ObjectQuery().select(Reservation.class).active(Reservation.class).equals(Reservation.Properties.RESERVATION_STATE, "BOOKED").not().isNull(Reservation.Properties.EXTERNAL_ID);
        query.selectFunc("TIMESTAMP(date, time) as 'visit_datetime'");
        query.havingFunction("visit_datetime BETWEEN '" + DateTimeUtils.getSQLTimestampFormat().format(minDate) + "' AND '" + DateTimeUtils.getSQLTimestampFormat().format(maxDate) + "'");
        return query;
    }

    public static ObjectQuery getUnarrivedReservationsQry(Date minDate, LogicalTable logicalTable) {
        ObjectQuery query = Query.select(Reservation.class).active(Reservation.class);
        query.not().equals(Reservation.Properties.RESERVATION_STATE, "ARRIVED");
        query.equals(Reservation.Properties.SECTION, logicalTable.getTableGroup());
        query.equals(Reservation.Properties.DATE, minDate, SQLDateType.DATE);
        query.greaterThan(Reservation.Properties.TIME, minDate, SQLDateType.TIME);
        query.not().isNull(Reservation.Properties.TABLES);
        query.orderBy(Reservation.Properties.TIME);
        return query;
    }
}

