/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.stock;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.Price;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.DomainQueries;
import ordermate.database.reports.stock.StockAreaReport;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesItemQuantity;
import ordermate.database.stock.StockArea;
import ordermate.internationalization.Internationalization;

public class StockAreaQueries
implements DomainQueries {
    public static final String DISPLAYLABEL_AREA = "Stock Area";
    public static final String DISPLAYLABEL_CATEGORY = "Category";
    public static final String DISPLAYLABEL_SALES = "Sales";
    public static final String DISPLAYLABEL_SALES_EX = MessageFormat.format("Sales (Ex {0})", Internationalization.getLiteralFor("GST"));
    public static final String DISPLAYLABEL_COGS = "Est. Cost";
    public static final String DISPLAYLABEL_GP = "GP";
    public static final String DISPLAYLABEL_GP_PERCENT = "GP %";
    public static final String GET_ALL_ACTIVE = "SELECT * FROM stock_area WHERE system_state = 'ACTIVE' ORDER BY Name ";
    public static final String GET_FOR_NAME = "SELECT * FROM stock_area WHERE Name = ? AND system_state = 'ACTIVE' LIMIT 1 ";
    public static final int[] columnsToDisplay = new int[]{6, 8, 0, 1, 2, 3, 4};
    public static final String[] displayColumns = new String[]{"Stock Area", "Category", "Sales", DISPLAYLABEL_SALES_EX, "Est. Cost", "GP", "GP %"};

    @Deprecated
    public static ObjectQuery getStockAreaCOGSQuery(Date from, Date to) {
        return Query.select(StockArea.Properties.ID, "stock_area_id").select(StockArea.Properties.LABEL, "stock_area").sumMultiplication(SalesComponent.Properties.INGREDIENT_COST_EX_TAX, SalesItemQuantity.Properties.QUANTITY, "cogs").linkUsing(SalesItem.Properties.COMPONENT).linkUsing(SalesItemQuantity.Properties.SALES_LINE_ITEM).linkUsing(SalesItemQuantity.Properties.TERMINAL).linkUsing(Terminal.Properties.STOCK_AREA).wherePropertyBetween(SalesItemQuantity.Properties.CREATION_TIME, from, to, SQLDateType.TIMESTAMP).groupBy(StockArea.Properties.ID).orderBy(StockArea.Properties.LABEL);
    }

    public static List<StockAreaReport> getStockAreaReports(Timestamp startTime, Timestamp endTime) {
        Object[][] salesAndCOGSArray = PersistenceManager.getPersistenceDelegate().executeQuery(Reports.GetSalesAndCOGS.QUERY_PER_AREA, new Object[]{startTime, endTime});
        ArrayList<StockAreaReport> stockAreaReports = new ArrayList<StockAreaReport>();
        for (Object[] salesAndCogsRow : salesAndCOGSArray) {
            StockAreaReport stockAreaReport = new StockAreaReport();
            stockAreaReport.setStockArea((String)salesAndCogsRow[6]);
            stockAreaReport.setCogs(new Price((Number)salesAndCogsRow[2], Price.DEFAULT_ROUND_AMOUNT));
            stockAreaReports.add(stockAreaReport);
        }
        return stockAreaReports;
    }

    public static final class Reports {

        public static final class GetOutgoingTransferValue {
            public static final int AREA_NAME = 0;
            public static final int AREA_ID = 1;
            public static final int VALUE = 2;
            public static final int VALUE_EX_TAX = 3;
            public static final String QUERY;
            public static final String QUERY_FOR_AREA;

            static {
                SelectQuery baseQuery = new SelectQuery();
                baseQuery.addSelectValue("stock_area.Name ");
                baseQuery.addSelectValue("stock_area.ID ");
                baseQuery.addSelectValue("-SUM(stock_usage.HistoricalCost) AS Value ");
                baseQuery.addSelectValue("-SUM(IF(stock_item.tax_included, stock_usage.HistoricalCost * " + SystemProperty.getInstance().getBaseTaxFactor() + ", stock_usage.HistoricalCost)) AS ValueExTax ");
                baseQuery.addFromTable("stock_area");
                baseQuery.addFromTable("stock_usage");
                baseQuery.addFromTable("stock_item");
                baseQuery.addWhere("stock_usage.FK_stock_area = stock_area.ID ");
                baseQuery.addWhere("stock_usage.system_state = 'ACTIVE'");
                baseQuery.addWhere("stock_usage.FK_stock_item = stock_item.ID ");
                baseQuery.addWhere("stock_usage.usage_state = 'TRANSFER' ");
                baseQuery.addWhere("stock_usage.CreationDate >= ? ");
                baseQuery.addWhere("stock_usage.CreationDate <= ? ");
                baseQuery.addOrderBy("stock_area.Name");
                baseQuery.addGroupBy("stock_area.ID");
                QUERY = baseQuery.getSQL();
                SelectQuery queryForArea = new SelectQuery(baseQuery);
                queryForArea.addWhere("stock_area.ID = ? ");
                QUERY_FOR_AREA = queryForArea.getSQL();
            }
        }

        public static final class GetIncomingTransferValue {
            public static final int AREA_NAME = 0;
            public static final int AREA_ID = 1;
            public static final int VALUE = 2;
            public static final int VALUE_EX_TAX = 3;
            public static final String QUERY;
            public static final String QUERY_FOR_AREA;

            static {
                SelectQuery baseQuery = new SelectQuery();
                baseQuery.addSelectValue("stock_area.Name ");
                baseQuery.addSelectValue("stock_area.ID ");
                baseQuery.addSelectValue("SUM(stock_usage.HistoricalCost) AS Value ");
                baseQuery.addSelectValue("SUM(IF(stock_item.tax_included, stock_usage.HistoricalCost * " + SystemProperty.getInstance().getBaseTaxFactor() + ", stock_usage.HistoricalCost)) AS ValueExTax ");
                baseQuery.addFromTable("stock_area");
                baseQuery.addFromTable("stock_usage");
                baseQuery.addFromTable("stock_item");
                baseQuery.addWhere("stock_usage.FK_stock_area_transfer_to = stock_area.ID ");
                baseQuery.addWhere("stock_usage.FK_stock_item = stock_item.ID");
                baseQuery.addWhere("stock_usage.system_state = 'ACTIVE'");
                baseQuery.addWhere("stock_usage.usage_state = 'TRANSFER' ");
                baseQuery.addWhere("stock_usage.CreationDate >= ? ");
                baseQuery.addWhere("stock_usage.CreationDate <= ? ");
                baseQuery.addOrderBy("stock_area.Name");
                baseQuery.addGroupBy("stock_area.ID");
                QUERY = baseQuery.getSQL();
                SelectQuery queryForArea = new SelectQuery(baseQuery);
                queryForArea.addWhere("stock_area.ID = ? ");
                QUERY_FOR_AREA = queryForArea.getSQL();
            }
        }

        public static final class GetSalesAndCOGS {
            public static final int SALES = 0;
            public static final int SALES_EX = 1;
            public static final int COGS = 2;
            public static final int GP = 3;
            public static final int GP_PERCENT = 4;
            public static final int AREA_ID = 5;
            public static final int AREA_NAME = 6;
            public static final int CATEGORY_ID = 7;
            public static final int CATEGORY_NAME = 8;
            public static final String QUERY_PER_AREA;
            public static final String QUERY_FOR_AREA;
            public static final String QUERY_PER_AREA_CATEGORY;

            static {
                SelectQuery baseQuery = new SelectQuery();
                baseQuery.addSelectValue("SUM(sales_component.unit_price * sales_item_quantity.quantity) AS Sales ");
                baseQuery.addSelectValue("SUM((sales_component.unit_price - sales_component.unit_tax) * sales_item_quantity.quantity) AS SalesEx");
                baseQuery.addSelectValue("SUM(sales_component.unit_cost * sales_item_quantity.quantity) AS COGS ");
                baseQuery.addSelectValue("SUM((sales_component.unit_price - sales_component.unit_tax) * sales_item_quantity.quantity) - SUM(sales_component.unit_cost * sales_item_quantity.quantity) AS GP ");
                baseQuery.addSelectValue("(SUM((sales_component.unit_price - sales_component.unit_tax) * sales_item_quantity.quantity) - SUM(sales_component.unit_cost * sales_item_quantity.quantity)) / SUM((sales_component.unit_price - sales_component.unit_tax) * sales_item_quantity.quantity) AS GPPercent ");
                baseQuery.addSelectValue("stock_area.ID as AreaID");
                baseQuery.addSelectValue("stock_area.Name");
                baseQuery.addFromTable("config_terminal JOIN sales_item ON sales_item.FK_config_terminal = config_terminal.ID JOIN sales_item_quantity ON sales_item_quantity.FK_sales_item = sales_item.ID JOIN sales_component ON sales_component.FK_sales_item = sales_item.ID JOIN inventory_item ON sales_component.FK_inventory_item = inventory_item.ID JOIN inventory_category ON inventory_item.FK_inventory_category = inventory_category.ID JOIN inventory_group ON inventory_item.FK_inventory_group = inventory_group.ID LEFT JOIN stock_area_terminal_item ON stock_area_terminal_item.FK_config_terminal = config_terminal.ID AND stock_area_terminal_item.FK_inventory_item = inventory_item.ID LEFT JOIN stock_area_terminal_menugroup ON stock_area_terminal_menugroup.FK_config_terminal = config_terminal.ID AND stock_area_terminal_menugroup.FK_inventory_group = inventory_group.ID JOIN stock_area ON ((stock_area_terminal_item.FK_stock_area IS NULL AND stock_area_terminal_menugroup.FK_stock_area IS NULL AND config_terminal.FK_stock_area = stock_area.ID ) OR  (stock_area_terminal_item.FK_stock_area IS NULL AND stock_area_terminal_menugroup.FK_stock_area = stock_area.ID) OR stock_area_terminal_item.FK_stock_area = stock_area.ID)");
                baseQuery.addWhere("sales_item_quantity.creation_time BETWEEN ? AND ?");
                baseQuery.addGroupBy("stock_area.ID");
                baseQuery.addOrderBy("stock_area.Name");
                SelectQuery queryPerArea = new SelectQuery(baseQuery);
                QUERY_PER_AREA = queryPerArea.getSQL();
                SelectQuery queryForArea = new SelectQuery(baseQuery);
                queryForArea.addWhere("stock_area.ID = ? ");
                QUERY_FOR_AREA = queryForArea.getSQL();
                SelectQuery queryPerAreaCategory = new SelectQuery(baseQuery);
                queryPerAreaCategory.addGroupBy("inventory_category.ID");
                queryPerAreaCategory.addOrderBy("inventory_category.Name");
                queryPerAreaCategory.addSelectValue("inventory_category.ID");
                queryPerAreaCategory.addSelectValue("inventory_category.Name");
                QUERY_PER_AREA_CATEGORY = queryPerAreaCategory.getSQL();
            }
        }
    }
}

