/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.stock;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;

public class StockInventoryUsageLinkQueries {
    public static List getLinksToStockItem(StockItem item) {
        ObjectQuery query = Query.select(StockInventoryUsageLink.class).linkUsing(StockInventoryUsageLink.Properties.STOCK_ITEM).equals(StockInventoryUsageLink.Properties.STOCK_ITEM, item.getID());
        return PersistenceManager.getObjectList(StockInventoryUsageLink.class, query.toString(), new Object[0]);
    }

    public static List getLinksToInventoryUnit(InventoryItemUnit unit) {
        ObjectQuery query = Query.select(StockInventoryUsageLink.class).linkUsing(StockInventoryUsageLink.Properties.INVENTORY_ITEM_UNIT).equals(StockInventoryUsageLink.Properties.INVENTORY_ITEM_UNIT, unit.getID());
        return PersistenceManager.getObjectList(StockInventoryUsageLink.class, query.toString(), new Object[0]);
    }

    public static List getLinksWithLiquorFileIDs() {
        ObjectQuery query = Query.select(StockInventoryUsageLink.class).not().isNull(StockInventoryUsageLink.Properties.LIQUORFILE_ID);
        return PersistenceManager.getObjectList(StockInventoryUsageLink.class, query.toString());
    }

    public static List getLinksWithLiquorFileID(Long id) {
        ObjectQuery query = Query.select(StockInventoryUsageLink.class).equals(StockInventoryUsageLink.Properties.LIQUORFILE_ID, id);
        return PersistenceManager.getObjectList(StockInventoryUsageLink.class, query.toString(), new Object[0]);
    }

    public static List getLinksToStockItemAndLiquorFileID(StockItem item, Long id) {
        ObjectQuery query = Query.select(StockInventoryUsageLink.class).linkUsing(StockInventoryUsageLink.Properties.STOCK_ITEM).equals(StockInventoryUsageLink.Properties.STOCK_ITEM, item.getID()).equals(StockInventoryUsageLink.Properties.LIQUORFILE_ID, id);
        return PersistenceManager.getObjectList(StockInventoryUsageLink.class, query.toString(), new Object[0]);
    }

    public static StockItem getStockItemByLiquorFileID(Long id) {
        ObjectQuery query = Query.select(StockInventoryUsageLink.class).equals(StockInventoryUsageLink.Properties.LIQUORFILE_ID, id);
        List<StockInventoryUsageLink> stockInvUsageLinksWithID = PersistenceManager.getObjectList(StockInventoryUsageLink.class, query.toString());
        return stockInvUsageLinksWithID.isEmpty() ? null : stockInvUsageLinksWithID.get(0).getStockItem();
    }

    public static InventoryItem getInventoryItemByLiquorFileID(Long id) {
        ObjectQuery query = Query.select(StockInventoryUsageLink.class).equals(StockInventoryUsageLink.Properties.LIQUORFILE_ID, id);
        List<StockInventoryUsageLink> stockInvUsageLinksWithID = PersistenceManager.getObjectList(StockInventoryUsageLink.class, query.toString());
        HashSet<InventoryItemUnit> inventoryItemUnitsWithID = new HashSet<InventoryItemUnit>();
        for (StockInventoryUsageLink stockInventoryUsageLink : stockInvUsageLinksWithID) {
            inventoryItemUnitsWithID.add(stockInventoryUsageLink.getInventoryItemUnit());
        }
        HashSet<InventoryItem> inventoryItemsWithID = new HashSet<InventoryItem>();
        for (InventoryItemUnit invItemUnit : inventoryItemUnitsWithID) {
            inventoryItemsWithID.add(invItemUnit.getItem());
        }
        ArrayList arrayList = new ArrayList(inventoryItemsWithID);
        return arrayList.isEmpty() ? null : (InventoryItem)arrayList.get(0);
    }

    public StockInventoryUsageLinkQueries(String tableName, Class<StockInventoryUsageLink> class1) {
    }
}

