/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.stock;

import au.com.ordermate.sql.queries.SelectQuery;
import ordermate.database.misc.SystemProperty;

public class StockInvoiceQueries {
    public static final String GET_ALL_ACTIVE = "SELECT stock_invoice.* FROM stock_invoice WHERE stock_invoice.system_state = 'ACTIVE' ORDER BY CreationDate ";
    public static final String GET_FOR_DATES = "SELECT stock_invoice.* FROM stock_invoice WHERE stock_invoice.system_state = 'ACTIVE' AND Date >= ? AND Date <= ? ORDER BY Date ";
    public static final String GET_FOR_CREATION_DATES = "SELECT stock_invoice.* FROM stock_invoice WHERE stock_invoice.system_state = 'ACTIVE' AND CreationDate >= ? AND CreationDate <= ? ORDER BY CreationDate ";
    public static final String GET_FOR_INVOICE_NUMBER = "SELECT stock_invoice.* FROM stock_invoice WHERE stock_invoice.system_state = 'ACTIVE' AND InvoiceNumber = ? LIMIT 1 ";

    public static final class Reports {

        public static final class GetInvoiceExtraCosts {
            public static final int EXTRA_VALUE = 0;
            public static final int EXTRA_VALUE_EX_TAX = 1;
            public static final int AREA_ID = 2;
            public static final int AREA_NAME = 3;
            public static final String QUERY;
            public static final String QUERY_PER_AREA;
            public static final String QUERY_FOR_AREA;

            static {
                SelectQuery baseQuery = new SelectQuery();
                baseQuery.addSelectValue("SUM(AdminCost + FreightCost - Discount) AS Value");
                baseQuery.addSelectValue("SUM(AdminCost + FreightCost - Discount) * " + SystemProperty.getInstance().getBaseTaxFactor() + " AS ValueExTax");
                baseQuery.addFromTable("stock_invoice");
                baseQuery.addFromTable("stock_area");
                baseQuery.addWhere("stock_invoice.FK_stock_area = stock_area.ID");
                baseQuery.addWhere("stock_invoice.CreationDate >= ? ");
                baseQuery.addWhere("stock_invoice.CreationDate <= ? ");
                baseQuery.addWhere("stock_invoice.system_state = 'ACTIVE'");
                baseQuery.addWhere("NOT(stock_invoice.invoice_type = 'Purchase Order')");
                SelectQuery standardQuery = new SelectQuery(baseQuery);
                QUERY = standardQuery.getSQL();
                SelectQuery queryPerArea = new SelectQuery(baseQuery);
                queryPerArea.addSelectValue("stock_area.ID");
                queryPerArea.addSelectValue("stock_area.Name");
                queryPerArea.addGroupBy("stock_area.ID");
                queryPerArea.addOrderBy("stock_area.Name");
                QUERY_PER_AREA = queryPerArea.getSQL();
                SelectQuery queryForArea = new SelectQuery(baseQuery);
                queryForArea.addWhere("stock_area.ID = ?");
                QUERY_FOR_AREA = queryForArea.getSQL();
            }
        }

        public static final class GetInvoiceCost {
            public static final int INVOICE_VALUE = 0;
            public static final int INVOICE_VALUE_EX_TAX = 1;
            public static final int AREA_ID = 2;
            public static final String QUERY;
            public static final String QUERY_PER_AREA;
            public static final String QUERY_FOR_AREA;

            static {
                SelectQuery baseQuery = new SelectQuery();
                baseQuery.addSelectValue("SUM(stock_invoice_entry.PricePaid) AS Value");
                baseQuery.addSelectValue("SUM(IF(stock_invoice_entry.tax_included, stock_invoice_entry.PricePaid * " + SystemProperty.getInstance().getBaseTaxFactor() + ", stock_invoice_entry.PricePaid)) AS ValueExTax");
                baseQuery.addFromTable("stock_invoice");
                baseQuery.addFromTable("stock_invoice_entry");
                baseQuery.addFromTable("stock_area");
                baseQuery.addWhere("stock_invoice_entry.FK_stock_invoice = stock_invoice.ID");
                baseQuery.addWhere("stock_invoice.FK_stock_area = stock_area.ID");
                baseQuery.addWhere("stock_invoice.system_state = 'ACTIVE'");
                baseQuery.addWhere("stock_invoice_entry.system_state = 'ACTIVE'");
                baseQuery.addWhere("stock_invoice.CreationDate >= ? ");
                baseQuery.addWhere("stock_invoice.CreationDate <= ? ");
                baseQuery.addWhere("NOT(stock_invoice.invoice_type = 'Purchase Order')");
                SelectQuery standardQuery = new SelectQuery(baseQuery);
                QUERY = standardQuery.getSQL();
                SelectQuery queryPerArea = new SelectQuery(baseQuery);
                queryPerArea.addSelectValue("stock_area.ID");
                queryPerArea.addGroupBy("stock_area.ID");
                queryPerArea.addOrderBy("stock_area.Name");
                QUERY_PER_AREA = queryPerArea.getSQL();
                SelectQuery queryForArea = new SelectQuery(baseQuery);
                queryForArea.addWhere("stock_area.ID = ?");
                QUERY_FOR_AREA = queryForArea.getSQL();
            }
        }
    }
}

