/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.stock;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import au.com.ordermate.persistence.list.QueryList;
import au.com.ordermate.sql.SQL;
import java.util.List;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockSupplier;
import ordermate.database.stock.usagelink.StockItemIngredientLink;

public class StockItemQueries {
    public static final String GET_ALL_ACTIVE = "SELECT * FROM stock_item WHERE system_state = 'ACTIVE' ORDER BY Name";
    private static final LocalCacheListManager<StockItem> allStockItems = new LocalCacheListManager<StockItem>(QueryList.createQueryList(StockItem.class, "SELECT * FROM stock_item WHERE system_state = 'ACTIVE' ORDER BY Name"));
    public static final String GET_ALL_LABELS = "SELECT Name FROM stock_item WHERE system_state = 'ACTIVE' ORDER BY Name";
    public static final String GET_BY_NAME = "SELECT * FROM stock_item WHERE Name = ? AND system_state = 'ACTIVE'";
    public static final String GET_BY_SUPPLIER = "SELECT stock_item.* FROM stock_item, stock_item_suppliers WHERE stock_item_suppliers.FK_stock_supplier = ? AND stock_item.ID = stock_item_suppliers.FK_stock_item AND stock_item.system_state = 'ACTIVE' ORDER BY stock_item.Name";
    public static final String GET_FROM_AREA = "SELECT stock_item.* FROM stock_item, stock_on_hand WHERE stock_item.ID = stock_on_hand.FK_stock_item AND stock_on_hand.FK_stock_area = ? AND stock_on_hand.Quantity > 0 AND stock_item.system_state = 'ACTIVE' AND stock_on_hand.system_state = 'ACTIVE' ORDER BY stock_item.Name";
    public static final String GET_ALL_FROM_AREA = "SELECT stock_item.* FROM stock_item, stock_on_hand WHERE stock_item.ID = stock_on_hand.FK_stock_item AND stock_on_hand.FK_stock_area = ? AND stock_item.system_state = 'ACTIVE' AND stock_on_hand.system_state = 'ACTIVE' ORDER BY stock_item.Name";
    public static final String GET_BY_BARCODE = "SELECT stock_item.* FROM stock_item, stock_barcodes WHERE stock_barcodes.barcode = ? AND stock_barcodes.FK_stock_item = stock_item.ID AND stock_item.system_state = 'ACTIVE' ORDER BY stock_item.Name";
    public static final String GET_BY_PROD_CODE = "SELECT DISTINCT stock_item.* FROM stock_item, stock_item_suppliers WHERE " + SQL.join("stock_item_suppliers", "stock_item") + "AND stock_item_suppliers.ProductCode = ? LIMIT 1";
    public static final String GET_BY_SUPPLIER_AND_CODE = "SELECT stock_item.* FROM stock_item, stock_item_suppliers WHERE " + SQL.join("stock_item_suppliers", "stock_item") + "AND stock_item_suppliers.FK_stock_supplier = ? AND stock_item_suppliers.ProductCode = ? LIMIT 1";
    public static final String GET_STOCKABLE_IN_AREA = "SELECT stock_item.* FROM stock_item, stock_on_hand WHERE stock_item.ID = stock_on_hand.FK_stock_item AND stock_on_hand.FK_stock_area = ? AND stock_item.system_state = 'ACTIVE' AND stock_on_hand.StockAllowed = 1 ORDER BY Name";
    public static final String CHECK_MISSING_STOCK_GROUPS = "SELECT * FROM stock_item LEFT OUTER JOIN stock_group ON stock_item.FK_stock_group = stock_group.ID WHERE stock_item.system_state = 'ACTIVE' AND (stock_group.ID IS null OR stock_group.system_state = 'DELETED')";

    public StockItemQueries(String tableName, Class<StockItem> class1) {
    }

    public static List<StockItem> getStockItems() {
        return allStockItems.getList();
    }

    public static void clearCache() {
        allStockItems.clearCache();
    }

    public static StockItem getStockItemsForIdentifier(Integer identifier) {
        String sqlCmd = Query.select(StockItem.class).active(StockItem.class).equals(StockItem.Properties.STOCK_IDENTIFIER, identifier).toString();
        Object[] params = new Object[]{};
        return PersistenceManager.getObject(StockItem.class, sqlCmd, params);
    }

    public static String[] getStockItemLabels() {
        Object[][] itemNames = PersistenceManager.getPersistenceDelegate().executeQuery(GET_ALL_LABELS, new Object[0]);
        String[] names = new String[itemNames.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = (String)itemNames[i][0];
        }
        return names;
    }

    public static List getStockItems(StockArea stockArea) {
        Object[] params = new Object[]{stockArea.getID()};
        return PersistenceManager.getObjectList(StockItem.class, GET_FROM_AREA, params);
    }

    public static List<StockItem> getAllStockItems(StockArea stockArea) {
        Object[] params = new Object[]{stockArea.getID()};
        return PersistenceManager.getObjectList(StockItem.class, GET_ALL_FROM_AREA, params);
    }

    public static List getStockItemsForBarcode(String barcode) {
        Object[] params = new Object[]{barcode};
        return PersistenceManager.getObjectList(StockItem.class, GET_BY_BARCODE, params);
    }

    public static StockItem getStockItemForSupplierAndCode(StockSupplier supplier, String prodCode) {
        Object[] params = new Object[]{supplier.getID(), prodCode};
        return PersistenceManager.getObject(StockItem.class, GET_BY_SUPPLIER_AND_CODE, params);
    }

    public static StockItem getStockItemForCode(String prodCode) {
        Object[] params = new Object[]{prodCode};
        return PersistenceManager.getObject(StockItem.class, GET_BY_PROD_CODE, params);
    }

    public static StockItem getStockItemForName(String name) {
        Object[] params = new Object[]{name};
        return PersistenceManager.getObject(StockItem.class, GET_BY_NAME, params);
    }

    public static List getStockItemsForSupplier(StockSupplier supplier) {
        Object[] params = new Object[]{supplier.getID()};
        return PersistenceManager.getObjectList(StockItem.class, GET_BY_SUPPLIER, params);
    }

    public static List getStockItemsStockableIn(StockArea area) {
        Object[] params = new Object[]{area.getID()};
        return PersistenceManager.getObjectList(StockItem.class, GET_STOCKABLE_IN_AREA, params);
    }

    public static List<StockItem> getStockItemsWithoutStockGroup() {
        return PersistenceManager.getObjectList(StockItem.class, CHECK_MISSING_STOCK_GROUPS, null);
    }

    public static List<StockItem> getStockItemsForGroup(StockGroup stockGroup) {
        String sqlCmd = "";
        sqlCmd = stockGroup == null ? Query.select(StockItem.class).active(StockItem.class).isNull(StockItem.Properties.STOCK_GROUP).toString() : Query.select(StockItem.class).active(StockItem.class).equals((PropertiedObject.Property)StockItem.Properties.STOCK_GROUP, stockGroup.intID()).toString();
        Object[] params = new Object[]{};
        return PersistenceManager.getObjectList(StockItem.class, sqlCmd, params);
    }

    public static boolean stockItemsExist() {
        String sql = Query.select(StockItem.class).active(StockItem.class).limit(1).toString();
        return PersistenceManager.getObject(StockItem.class, sql, null) != null;
    }

    public static ObjectQuery getStockItemsWithIngredientsQuery() {
        return Query.select(StockItem.class).distinct().active(StockItem.class).linkUsing(StockItem.Properties.STOCK_INGREDIENT_LINKS).not().isNull(StockItemIngredientLink.Properties.STOCK_ITEM);
    }

    public static List<StockItem> getStockItemsWithIngredients() {
        ObjectQuery query = StockItemQueries.getStockItemsWithIngredientsQuery();
        return PersistenceManager.getObjectList(StockItem.class, query.toString(), null);
    }
}

