/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.stock;

import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.util.FinanceUtils;
import java.text.MessageFormat;
import java.util.List;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.DomainQueries;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockGroup;
import ordermate.database.stock.StockItem;

public class StockOnHandQueries
implements DomainQueries {
    public static final String GET_VALUE_FOR_ITEM_AREA = "SELECT Quantity FROM stock_on_hand WHERE FK_stock_item = ? AND FK_stock_area = ? ";
    public static final String GET_FOR_ITEM_AREA = "SELECT * FROM stock_on_hand WHERE FK_stock_item = ? AND FK_stock_area = ? ";

    public static final class Reports {
        private static final String GST = SystemProperty.getInstance().getBaseTaxLabel();
        public static final String DISPLAYLABEL_TOTAL_INC = MessageFormat.format("Total cost (Inc {0})", GST);
        public static final String DISPLAYLABEL_TOTAL_EX = MessageFormat.format("Total cost (Ex {0})", GST);
        public static final String DISPLAYLABEL_UNIT_COST_INC = MessageFormat.format("Unit cost (Inc {0})", GST);
        public static final String DISPLAYLABEL_UNIT_COST_EX = MessageFormat.format("Unit cost (Ex {0})", GST);
        public static final String DISPLAYLABEL_GROUP = "Group";
        public static final String[] DISPLAY_COLUMNS = new String[]{"Group", "Name", "Qty On Hand", DISPLAYLABEL_UNIT_COST_EX, DISPLAYLABEL_UNIT_COST_INC, DISPLAYLABEL_TOTAL_EX, DISPLAYLABEL_TOTAL_INC};
        public static int[] COLUMNS_TO_SHOW = new int[]{2, 0, 5, 8, 6, 9, 7};

        public static final class GetStockOnHandByTax {
            public static final int TOTAL_COST_INC = 0;
            public static final int INC_TAX = 1;
            private static final SelectQuery BASE_QUERY = new SelectQuery();

            public static SelectQuery getQuery() {
                return BASE_QUERY;
            }

            static {
                BASE_QUERY.addFromTable("stock_on_hand");
                BASE_QUERY.addFromTable("stock_item");
                BASE_QUERY.addSelectValue("SUM(stock_on_hand.Quantity * stock_on_hand.AverageCost / stock_item.Quantity) AS TotalCostInc");
                BASE_QUERY.addSelectValue("stock_item.tax_included");
                BASE_QUERY.addWhere(SQL.join("stock_on_hand", "stock_item"));
                BASE_QUERY.addWhere(SQL.isActive("stock_item"));
                BASE_QUERY.addWhere(SQL.isActive("stock_on_hand"));
                BASE_QUERY.addGroupBy("stock_item.tax_included");
                BASE_QUERY.addOrderBy("stock_item.tax_included");
            }
        }

        public static final class GetStockOnHandDetail {
            public static final int ITEM_NAME = 0;
            public static final int ITEM_ID = 1;
            public static final int GROUP_NAME = 2;
            public static final int ITEM_DISPLAY_MEASURE = 3;
            public static final int ITEM_QUANTITY_PER_UNIT = 4;
            public static final int TOTAL_QUANTITY = 5;
            public static final int UNIT_COST_INC = 6;
            public static final int TOTAL_COST_INC = 7;
            public static final int UNIT_COST_EX = 8;
            public static final int TOTAL_COST_EX = 9;
            private static final String TAX_EX_FORMULA = "IF(stock_item.tax_included, " + FinanceUtils.getRemoveTaxMultiplier(SystemProperty.getInstance().getBaseTaxRate()) + " , IF(stock_item.replacement_cost_match_pre_prod, " + FinanceUtils.getRemoveTaxMultiplier(SystemProperty.getInstance().getBaseTaxRate()) + ", 1))";
            private static final SelectQuery BASE_QUERY = new SelectQuery();

            public static SelectQuery getQuery(StockArea area, List groups, StockItem item) {
                SelectQuery query = new SelectQuery(BASE_QUERY);
                if (item != null) {
                    query.addWhere("stock_on_hand.FK_stock_item = " + item.getID());
                }
                if (area != null) {
                    query.addWhere("stock_on_hand.FK_stock_area = " + area.getID());
                }
                if (groups != null && !groups.isEmpty()) {
                    String[] conditions = new String[groups.size()];
                    for (int i = 0; i < groups.size(); ++i) {
                        StockGroup group = (StockGroup)groups.get(i);
                        conditions[i] = "stock_group.ID = " + group.getID();
                    }
                    query.addWhereOr(conditions);
                }
                return query;
            }

            static {
                BASE_QUERY.addFromTable("stock_on_hand");
                BASE_QUERY.addFromTable("stock_item");
                BASE_QUERY.addFromTable("stock_area");
                BASE_QUERY.addFromTable("stock_group");
                BASE_QUERY.addSelectValue("stock_item.Name");
                BASE_QUERY.addSelectValue("stock_item.ID");
                BASE_QUERY.addSelectValue("stock_group.Name");
                BASE_QUERY.addSelectValue("stock_item.fk_display_measure_unit_container as unitContainer");
                BASE_QUERY.addSelectValue("stock_item.Quantity");
                BASE_QUERY.addSelectValue("SUM(stock_on_hand.Quantity) AS SOHQuantity");
                BASE_QUERY.addSelectValue("IF (SUM(stock_on_hand.Quantity) != 0, (SUM(stock_on_hand.Quantity * stock_on_hand.AverageCost / stock_item.Quantity) * stock_item.Quantity)  / SUM(stock_on_hand.Quantity), AVG(stock_on_hand.AverageCost)) AS UnitCostInc");
                BASE_QUERY.addSelectValue("SUM(stock_on_hand.Quantity * stock_on_hand.AverageCost / stock_item.Quantity) AS TotalCostInc");
                BASE_QUERY.addSelectValue("IF (SUM(stock_on_hand.Quantity) != 0, (SUM(stock_on_hand.Quantity * stock_on_hand.AverageCost / stock_item.Quantity) * stock_item.Quantity)  / SUM(stock_on_hand.Quantity), AVG(stock_on_hand.AverageCost)) * " + TAX_EX_FORMULA + " AS UnitCostEx");
                BASE_QUERY.addSelectValue("SUM(stock_on_hand.Quantity * stock_on_hand.AverageCost / stock_item.Quantity) * " + TAX_EX_FORMULA + " AS TotalCostEx");
                BASE_QUERY.addWhereOr(new String[]{"stock_on_hand.StockAllowed", "stock_on_hand.Quantity <> 0"});
                BASE_QUERY.addWhere(SQL.join("stock_on_hand", "stock_item", "stock_group"));
                BASE_QUERY.addWhere(SQL.join("stock_on_hand", "stock_area"));
                BASE_QUERY.addWhere(SQL.isActive("stock_item"));
                BASE_QUERY.addWhere(SQL.isActive("stock_on_hand"));
                BASE_QUERY.addWhere(SQL.isActive("stock_area"));
                BASE_QUERY.addGroupBy("stock_item.ID");
                BASE_QUERY.addOrderBy("stock_item.Name", true);
            }
        }

        public static final class GetStockOnHandValue {
            public static final int VALUE = 0;
            public static final int VALUE_EX_TAX = 1;
            public static final int AREA_ID = 2;
            private static final SelectQuery BASE_QUERY = new SelectQuery();

            public static String getQueryPerArea() {
                SelectQuery query = new SelectQuery(BASE_QUERY);
                query.addSelectValue("stock_area.ID");
                query.addGroupBy("stock_area.ID");
                query.addOrderBy("stock_area.Name");
                return query.getSQL();
            }

            public static String getQuery(StockItem item, StockArea area) {
                SelectQuery query = new SelectQuery(BASE_QUERY);
                if (item != null) {
                    query.addWhere("stock_item.ID = " + item.getID());
                }
                if (area != null) {
                    query.addWhere("stock_area.ID = " + area.getID());
                }
                return query.getSQL();
            }

            static {
                BASE_QUERY.addSelectValue("SUM(stock_on_hand.Quantity * stock_on_hand.AverageCost / stock_item.Quantity) AS Value");
                BASE_QUERY.addSelectValue("SUM(IF(stock_item.tax_included, stock_on_hand.Quantity * stock_on_hand.AverageCost / stock_item.Quantity * " + SystemProperty.getInstance().getBaseTaxFactor() + ", stock_on_hand.Quantity * stock_on_hand.AverageCost / stock_item.Quantity)) AS ValueExTax");
                BASE_QUERY.addFromTable("stock_on_hand");
                BASE_QUERY.addFromTable("stock_item");
                BASE_QUERY.addFromTable("stock_area");
                BASE_QUERY.addWhere("stock_on_hand.FK_stock_area = stock_area.ID");
                BASE_QUERY.addWhere("stock_on_hand.FK_stock_item = stock_item.ID");
                BASE_QUERY.addWhere("stock_item.system_state = 'ACTIVE'");
                BASE_QUERY.addWhere("stock_area.system_state = 'ACTIVE'");
            }
        }
    }
}

