/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.stock;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.sql.queries.SelectQuery;
import java.util.Date;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.DomainQueries;
import ordermate.database.stock.StockTake;

public class StockTakeQueries
implements DomainQueries {
    public StockTakeQueries(String string, Class<StockTake> class1) {
    }

    public static ObjectQuery getLastCompletedStockTake(Date date) {
        ObjectQuery query = StockTakeQueries.getLastStockTake(date, SQLDateType.TIMESTAMP);
        query.equals(StockTake.Properties.LIVE, 0.0);
        return query;
    }

    public static ObjectQuery getFirstCompletedStockTake(Date date) {
        ObjectQuery query = StockTakeQueries.getFirstStockTake(date, SQLDateType.TIMESTAMP);
        query.equals(StockTake.Properties.LIVE, 0.0);
        return query;
    }

    public static ObjectQuery getLastStockTake(Date date, SQLDateType dateType) {
        ObjectQuery query = Query.select(StockTake.class).lessThanOrEqual(StockTake.Properties.END_DATE, date, dateType).active(StockTake.class).orderByDesc(StockTake.Properties.END_DATE);
        return query;
    }

    public static ObjectQuery getFirstStockTake(Date date, SQLDateType dateType) {
        ObjectQuery query = Query.select(StockTake.class).greaterThanOrEqual(StockTake.Properties.END_DATE, date, dateType).active(StockTake.class).orderBy(StockTake.Properties.END_DATE);
        return query;
    }

    public static final class Reports {

        public static final class GetStockTakeValue {
            public static final int VALUE = 0;
            public static final int VALUE_EX_TAX = 1;
            public static final int VARIANCE = 2;
            public static final int VARIANCE_EX_TAX = 3;
            public static final int AREA_ID = 4;
            public static final String QUERY_FOR_STOCKTAKE;
            public static final String QUERY_FOR_STOCKTAKE_AREA;
            private static final String STOCK_TAKE_VALUE_INC_TAX = "SUM(IF (stock_take.Live, IF (stock_take_entry.ActualQty IS NOT NULL, stock_take_entry.ActualQty * stock_on_hand.AverageCost / stock_item.Quantity, stock_on_hand.Quantity * stock_on_hand.AverageCost / stock_item.Quantity), IF (stock_take_entry.ActualQty IS NOT NULL, stock_take_entry.ActualQty, stock_take_entry.TheoreticalQty) * stock_take_entry.CostPerAtomicUnit ))";
            private static final String STOCK_TAKE_VALUE_EX_TAX;

            static {
                STOCK_TAKE_VALUE_EX_TAX = "SUM(IF (stock_take.Live, IF (stock_take_entry.ActualQty IS NOT NULL, stock_take_entry.ActualQty * IF(stock_item.tax_included, stock_on_hand.AverageCost * " + SystemProperty.getInstance().getBaseTaxFactor() + ", stock_on_hand.AverageCost ) / stock_item.Quantity, stock_on_hand.Quantity * IF(stock_item.tax_included, stock_on_hand.AverageCost * " + SystemProperty.getInstance().getBaseTaxFactor() + ", stock_on_hand.AverageCost ) / stock_item.Quantity), IF (stock_take_entry.ActualQty IS NOT NULL, stock_take_entry.ActualQty, stock_take_entry.TheoreticalQty) * IF(stock_item.tax_included, stock_take_entry.CostPerAtomicUnit * " + SystemProperty.getInstance().getBaseTaxFactor() + ", stock_take_entry.CostPerAtomicUnit)))";
                SelectQuery baseQuery = new SelectQuery();
                baseQuery.addSelectValue("SUM(IF (stock_take.Live, IF (stock_take_entry.ActualQty IS NOT NULL, stock_take_entry.ActualQty * stock_on_hand.AverageCost / stock_item.Quantity, stock_on_hand.Quantity * stock_on_hand.AverageCost / stock_item.Quantity), IF (stock_take_entry.ActualQty IS NOT NULL, stock_take_entry.ActualQty, stock_take_entry.TheoreticalQty) * stock_take_entry.CostPerAtomicUnit )) AS StockTakeValue ");
                baseQuery.addSelectValue(STOCK_TAKE_VALUE_EX_TAX + " AS StockTakeValueEx");
                baseQuery.addSelectValue("SUM( IF (stock_take_entry.ActualQty IS NULL, 0, IF(stock_take.Live, (stock_take_entry.ActualQty - stock_on_hand.Quantity) * stock_on_hand.AverageCost / stock_item.Quantity, (stock_take_entry.ActualQty - stock_take_entry.TheoreticalQty) * stock_take_entry.CostPerAtomicUnit))) AS Variance");
                baseQuery.addSelectValue("SUM( IF (stock_take_entry.ActualQty IS NULL, 0, IF(stock_take.Live, (stock_take_entry.ActualQty - stock_on_hand.Quantity) * IF(stock_item.tax_included, stock_on_hand.AverageCost *" + SystemProperty.getInstance().getBaseTaxFactor() + ", stock_on_hand.AverageCost) / stock_item.Quantity, (stock_take_entry.ActualQty - stock_take_entry.TheoreticalQty) * IF(stock_item.tax_included, stock_take_entry.CostPerAtomicUnit *" + SystemProperty.getInstance().getBaseTaxFactor() + ", stock_take_entry.CostPerAtomicUnit)))) AS VarianceExTax");
                baseQuery.addSelectValue("stock_area.ID");
                baseQuery.addFromTable("stock_take");
                baseQuery.addFromTable("stock_take_entry");
                baseQuery.addFromTable("stock_item");
                baseQuery.addFromTable("stock_area");
                baseQuery.addFromTable("stock_on_hand");
                baseQuery.addWhere("stock_take_entry.FK_stock_take = stock_take.ID");
                baseQuery.addWhere("stock_on_hand.FK_stock_item = stock_take_entry.FK_stock_item");
                baseQuery.addWhere("stock_on_hand.FK_stock_area = stock_take_entry.FK_stock_area");
                baseQuery.addWhere("stock_take_entry.FK_stock_item = stock_item.ID");
                baseQuery.addWhere("stock_take_entry.FK_stock_area = stock_area.ID");
                baseQuery.addGroupBy("stock_area.ID");
                baseQuery.addOrderBy("stock_area.Name");
                SelectQuery queryForStockTake = new SelectQuery(baseQuery);
                queryForStockTake.addWhere("stock_take.ID = ?");
                QUERY_FOR_STOCKTAKE = queryForStockTake.getSQL();
                SelectQuery queryForStockTakeArea = new SelectQuery(queryForStockTake);
                queryForStockTakeArea.addWhere("stock_area.ID = ?");
                QUERY_FOR_STOCKTAKE_AREA = queryForStockTakeArea.getSQL();
            }
        }
    }
}

