/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.stock;

import au.com.ordermate.sql.queries.SelectQuery;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.DomainQueries;

public class StockUsageQueries
implements DomainQueries {

    public static final class Reports {

        public static final class GetUsageValue {
            public static final int AREA_NAME = 0;
            public static final int USAGE_STATE = 1;
            public static final int VALUE = 2;
            public static final int VALUE_EX_TAX = 3;
            public static final String QUERY;
            public static final String QUERY_FOR_AREA;
            public static final String QUERY_FOR_AREA_USAGE_STATE;

            static {
                SelectQuery baseQuery = new SelectQuery();
                baseQuery.addSelectValue("stock_area.Name");
                baseQuery.addSelectValue("stock_usage.usage_state");
                baseQuery.addSelectValue("SUM(stock_usage.HistoricalCost) AS UsageValue");
                baseQuery.addSelectValue("SUM(stock_usage.HistoricalCost * IF(stock_item.tax_included, " + SystemProperty.getInstance().getBaseTaxFactor() + ", 1)) AS UsageValueExTax");
                baseQuery.addFromTable("stock_usage");
                baseQuery.addFromTable("stock_area");
                baseQuery.addFromTable("stock_item");
                baseQuery.addWhere("stock_usage.FK_stock_item = stock_item.ID");
                baseQuery.addWhere("stock_usage.system_state = 'ACTIVE'");
                baseQuery.addWhere("stock_usage.FK_stock_area = stock_area.ID");
                baseQuery.addWhere("stock_usage.UsageDate >= ? ");
                baseQuery.addWhere("stock_usage.UsageDate <= ? ");
                baseQuery.addGroupBy("stock_area.ID");
                baseQuery.addGroupBy("usage_state");
                SelectQuery standardQuery = new SelectQuery(baseQuery);
                QUERY = standardQuery.getSQL();
                SelectQuery queryForArea = new SelectQuery(baseQuery);
                queryForArea.addWhere("stock_area.ID = ?");
                QUERY_FOR_AREA = queryForArea.getSQL();
                SelectQuery queryForAreaUsageState = new SelectQuery(baseQuery);
                queryForAreaUsageState.addWhere("stock_area.ID = ?");
                queryForAreaUsageState.addWhere("stock_usage.usage_state = ?");
                QUERY_FOR_AREA_USAGE_STATE = queryForAreaUsageState.getSQL();
            }
        }

        public static final class GetUsages {
            public static final int ITEM_NAME = 0;
            public static final int QUANTITY = 1;
            public static final int ITEM_DISPLAY_UNITS = 2;
            public static final int USAGE_DATE = 3;
            public static final int CREATION_DATE = 4;
            public static final int USER_NAME = 5;
            public static final int REASON = 6;
            public static final int VALUE = 7;
            public static final int VALUE_EX_TAX = 8;
            public static final int AREA_FROM_ID = 9;
            public static final int AREA_FROM_NAME = 10;
            public static final int AREA_TO_NAME = 11;
            public static final String QUERY;
            public static final String QUERY_PER_AREA;
            public static final String QUERY_TRANSFERS_PER_AREA;
            public static final String QUERY_FOR_AREA;

            static {
                SelectQuery baseQuery = new SelectQuery();
                baseQuery.addSelectValue("stock_item.Name");
                baseQuery.addSelectValue("stock_usage.Quantity");
                baseQuery.addSelectValue("stock_item.fk_display_measure_unit_container");
                baseQuery.addSelectValue("stock_usage.UsageDate");
                baseQuery.addSelectValue("stock_usage.CreationDate");
                baseQuery.addSelectValue("CONCAT(CONCAT(config_user.FirstName, ' '), config_user.Surname) AS UserName");
                baseQuery.addSelectValue("stock_usage.Reason");
                baseQuery.addSelectValue("SUM(stock_usage.HistoricalCost) AS UsageValue");
                baseQuery.addSelectValue("SUM(IF(stock_item.tax_included, stock_usage.HistoricalCost * " + SystemProperty.getInstance().getBaseTaxFactor() + ", stock_usage.HistoricalCost)) AS UsageValueExTax");
                baseQuery.addSelectValue("area_from.ID");
                baseQuery.addSelectValue("area_from.Name");
                baseQuery.addFromTable("stock_item");
                baseQuery.addFromTable("stock_area AS area_from");
                baseQuery.addFromTable("config_user");
                baseQuery.addFromTable("stock_usage");
                baseQuery.addWhere("stock_usage.FK_stock_item = stock_item.ID");
                baseQuery.addWhere("stock_usage.FK_stock_area = area_from.ID");
                baseQuery.addWhere("stock_usage.FK_config_user = config_user.ID");
                baseQuery.addWhere("stock_usage.system_state = 'ACTIVE'");
                baseQuery.addWhere("stock_usage.UsageDate >= ? ");
                baseQuery.addWhere("stock_usage.UsageDate <= ? ");
                baseQuery.addWhere("stock_usage.usage_state = ? ");
                SelectQuery standardQuery = new SelectQuery(baseQuery);
                standardQuery.addOrderBy("stock_usage.UsageDate");
                standardQuery.addGroupBy("stock_usage.ID");
                QUERY = standardQuery.getSQL();
                SelectQuery queryPerArea = new SelectQuery(baseQuery);
                queryPerArea.addGroupBy("area_from.ID");
                queryPerArea.addOrderBy("area_from.Name");
                QUERY_PER_AREA = queryPerArea.getSQL();
                SelectQuery queryTransfersPerArea = new SelectQuery(baseQuery);
                queryTransfersPerArea.addSelectValue("area_to.Name");
                queryTransfersPerArea.addFromTable("stock_area AS area_to");
                queryTransfersPerArea.addWhere("stock_usage.FK_stock_area_transfer_to = area_to.ID");
                queryTransfersPerArea.addGroupBy("area_from.ID");
                queryTransfersPerArea.addOrderBy("area_from.Name");
                QUERY_TRANSFERS_PER_AREA = queryTransfersPerArea.getSQL();
                SelectQuery queryForArea = new SelectQuery(baseQuery);
                queryForArea.addWhere("area_from.ID = ?");
                QUERY_FOR_AREA = queryForArea.getSQL();
            }
        }
    }
}

