/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.tables;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.queries.tables.PhysicalTableQueries;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;

public class LogicalTableQueries {
    public static List<LogicalTable> getAllLogicalTables() {
        return PersistenceManager.getObjectList(LogicalTable.class, Query.select(LogicalTable.class).active(LogicalTable.class).toString(), null);
    }

    public static LogicalTable getLogicalTableByID(long id) {
        return PersistenceManager.getObject(LogicalTable.class, Query.select(LogicalTable.class).equals(LogicalTable.Properties.ID, id).toString(), null);
    }

    public static LogicalTable getLogicalTableByPhysicalTableID(long id) {
        PhysicalTable phys = PersistenceManager.getObject(PhysicalTable.class, Query.select(PhysicalTable.class).equals(PhysicalTable.Properties.ID, id).active(PhysicalTable.class).toString(), null);
        if (phys != null && phys.getLogicalTable() != null && "ACTIVE".equals(phys.getLogicalTable().getSystemState())) {
            return phys.getLogicalTable();
        }
        return null;
    }

    public static String getTableNames(LogicalTable logicalTable) {
        if (logicalTable == null) {
            throw new IllegalArgumentException("Logical table CANNOT be NULL!");
        }
        StringBuilder sb = new StringBuilder();
        for (PhysicalTable table : logicalTable.getPhysicalTables()) {
            sb.append(table.getName()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static List<LogicalTable> getLogicalTables(String tableNames, TableGroup section) {
        if (tableNames == null || section == null) {
            throw new IllegalStateException("Please correct the section and tables!");
        }
        LinkedHashSet<LogicalTable> logicalTables = new LinkedHashSet<LogicalTable>();
        for (String tableName : StringUtils.splitToList(tableNames, ",")) {
            PhysicalTable physicalTable = PhysicalTableQueries.getPhysicalTable(tableName, section);
            if (physicalTable != null) {
                logicalTables.add(physicalTable.getLogicalTable());
                continue;
            }
            OrderMate.LOG.warn("There is no table information for the given table name: " + tableName + " and section: " + section.getName());
        }
        return new ArrayList<LogicalTable>(logicalTables);
    }

    public static LogicalTable getLogicalTableByPhysicalTableNamePreferOnline(String tableName) {
        return PersistenceManager.getObject(LogicalTable.class, Query.select(LogicalTable.class).linkUsing(PhysicalTable.Properties.LOGICAL_TABLE).linkUsing(LogicalTable.Properties.TABLE_GROUP).equals(PhysicalTable.Properties.CAN_ORDER_TO, Boolean.TRUE).equals(PhysicalTable.Properties.NAME, tableName).active(LogicalTable.class).orderBy(TableGroup.Properties.ONLINE, true).toString());
    }
}

