/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.queries.tables;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.queries.tables.TableGroupQueries;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.PhysicalTable;
import ordermate.database.tables.TableGroup;

public class PhysicalTableQueries {
    public static PhysicalTable getPhysicalTable(String tableName, String tableGroupName) {
        TableGroup tableGroup = TableGroupQueries.getTableGroupByName(tableGroupName);
        if (tableGroup == null) {
            return null;
        }
        PhysicalTable table = PersistenceManager.getObject(PhysicalTable.class, Query.select(PhysicalTable.class).equals(PhysicalTable.Properties.NAME, tableName).active(PhysicalTable.class).linkUsing(PhysicalTable.Properties.LOGICAL_TABLE, LogicalTable.Properties.ID).equals(LogicalTable.Properties.TABLE_GROUP, tableGroup).active(LogicalTable.class).toString(), null);
        if (table == null) {
            OrderMate.LOG.info("Invalid table, does not exist table: " + tableName);
        }
        return table;
    }

    public static PhysicalTable getPhysicalTable(String tableName, TableGroup tableGroup) {
        PhysicalTable table = PersistenceManager.getObject(PhysicalTable.class, Query.select(PhysicalTable.class).equals(PhysicalTable.Properties.NAME, tableName).active(PhysicalTable.class).linkUsing(PhysicalTable.Properties.LOGICAL_TABLE, LogicalTable.Properties.ID).equals(LogicalTable.Properties.TABLE_GROUP, tableGroup).active(LogicalTable.class).toString(), null);
        if (table == null) {
            OrderMate.LOG.info("Invalid table, does not exist table: " + tableName);
        }
        return table;
    }

    public static List<PhysicalTable> getPhysicalTables(List<String> tableNames, TableGroup tableGroup) {
        ObjectQuery query = Query.select(PhysicalTable.class).wherePropertyIn(PhysicalTable.Properties.NAME, tableNames).active(PhysicalTable.class).orderBy(PhysicalTable.Properties.NAME);
        if (tableGroup != null) {
            query.linkUsing(PhysicalTable.Properties.LOGICAL_TABLE, LogicalTable.Properties.ID).equals(LogicalTable.Properties.TABLE_GROUP, tableGroup).active(LogicalTable.class).toString();
        }
        List<PhysicalTable> physicalTables = PersistenceManager.getObjectList(PhysicalTable.class, query.toString(), null);
        if (tableGroup != null && physicalTables.size() > 1) {
            ArrayList<PhysicalTable> toRemove = new ArrayList<PhysicalTable>();
            TableGroup tg = physicalTables.get(0).getLogicalTable().getTableGroup();
            for (PhysicalTable nextPh : physicalTables) {
                if (tg.equals(nextPh.getLogicalTable().getTableGroup())) continue;
                toRemove.add(nextPh);
            }
            if (!toRemove.isEmpty()) {
                physicalTables.removeAll(toRemove);
            }
        }
        if (physicalTables == null) {
            OrderMate.LOG.info("Invalid table names, does not exist table: " + Arrays.toString(tableNames.toArray()));
        }
        return physicalTables;
    }

    public static List<PhysicalTable> getPhysicalTables(String tableNames, TableGroup tableGroup) {
        List<String> tables = StringUtils.splitToList(tableNames, ",");
        return PhysicalTableQueries.getPhysicalTables(tables, tableGroup);
    }

    public static boolean isJoinedTable(String tableName, String tableGroupName) {
        PhysicalTable physicalTable = PhysicalTableQueries.getPhysicalTable(tableName, tableGroupName);
        if (physicalTable == null) {
            return false;
        }
        List<PhysicalTable> tables = PersistenceManager.getObjectList(PhysicalTable.class, Query.select(PhysicalTable.class).equals(PhysicalTable.Properties.LOGICAL_TABLE, physicalTable.getLogicalTable()).active(PhysicalTable.class).toString(), null);
        return tables != null && tables.size() > 1;
    }

    public static boolean areTablesAvailable(List<PhysicalTable> physicalTables) {
        if (physicalTables == null || physicalTables.isEmpty()) {
            return false;
        }
        for (PhysicalTable table : physicalTables) {
            if (!table.getLogicalTable().hasAccount()) continue;
            return false;
        }
        return true;
    }

    public static boolean areTablesAvailable(String tableNames, TableGroup section) {
        HashSet<PhysicalTable> tables = new HashSet<PhysicalTable>(PhysicalTableQueries.getPhysicalTables(tableNames, section));
        for (PhysicalTable table : tables) {
            if (!table.getLogicalTable().hasAccount()) continue;
            return false;
        }
        return true;
    }

    public static boolean areJoinedTables(List<PhysicalTable> physicalTables) {
        if (physicalTables == null || physicalTables.isEmpty()) {
            return false;
        }
        LogicalTable logicalTable = physicalTables.get(0).getLogicalTable();
        for (PhysicalTable table : physicalTables) {
            if (logicalTable.equals(table.getLogicalTable())) continue;
            return false;
        }
        return true;
    }

    public static PhysicalTable getPhysicalTableByGroupDashName(String tableName) {
        TableGroup group;
        String[] splits;
        if (!StringUtils.isEmpty(tableName) && (splits = tableName.split("-", 2)).length == 2 && (group = PersistenceManager.getObject(TableGroup.class, Query.select(TableGroup.class).equals(TableGroup.Properties.NAME, splits[0]).toString())) != null) {
            return PersistenceManager.getObject(PhysicalTable.class, Query.select(PhysicalTable.class).linkUsing(PhysicalTable.Properties.LOGICAL_TABLE).equals(PhysicalTable.Properties.NAME, splits[1]).active(PhysicalTable.class).equals(LogicalTable.Properties.TABLE_GROUP, group).toString());
        }
        return null;
    }
}

