/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.finance.priceadjustment.PriceAdjustmentLevel;
import ordermate.database.finance.priceadjustment.PriceAdjustmentUnit;
import ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType;
import ordermate.database.inventory.InventoryItemPortion;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;
import ordermate.internationalization.Internationalization;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@AccessType(value="property")
public class AdjustmentsReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private static final String REFUND_STR = " - Refunded";
    private Reference<User> user;
    private String size;
    private Reference<InventoryItemPortion> portion;
    private Reference<SalesLineItem> salesItem;
    private AccountType accountType;
    private String itemName;
    private Date tradingDayDate;
    private Date creationDate;
    private Price savedTotal;
    private BigDecimal quantity;
    private PriceAdjustmentType adjustmentType;
    private String name;
    private PriceAdjustmentUnit unit;
    private Long inventoryItemUnitId;
    private Double amount;
    private PriceAdjustmentLevel level;
    private String source;
    private String target;
    private String targetUnit;
    private String value;
    private Long number;
    private String discountAmount;

    public AdjustmentsReport() {
        this.user = this.createReference(AdjustmentsReport.Properties.USER);
        this.portion = this.createReference(AdjustmentsReport.Properties.PORTION);
        this.salesItem = this.createReference(AdjustmentsReport.Properties.SALES_ITEM);
        this.target = null;
        this.targetUnit = null;
        this.number = 1L;
    }

    @Column(name="creation_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreationDate() {
        return this.creationDate;
    }

    @Column(name="saved_total_value")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getSavedTotal() {
        return this.savedTotal;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.finance.priceadjustment.inventory.PriceAdjustmentType")})
    @Column(name="type")
    public PriceAdjustmentType getAdjustmentType() {
        return this.adjustmentType;
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.finance.priceadjustment.PriceAdjustmentUnit")})
    @Column(name="unit")
    public PriceAdjustmentUnit getUnit() {
        return this.unit;
    }

    @Column(name="fk_inventory_item_unit")
    public Long getInventoryItemUnitId() {
        return this.inventoryItemUnitId;
    }

    public void setInventoryItemUnitId(Long theUnit) {
        this.inventoryItemUnitId = theUnit;
    }

    @Transient
    public String getValue() {
        if (this.value == null) {
            this.value = this.unit.getFormattedValue(this.amount);
        }
        return this.value;
    }

    @Column
    public Double getAmount() {
        return this.amount;
    }

    @Transient
    public BigDecimal getQuantity() {
        return this.quantity;
    }

    public void setQuantity(BigDecimal value) {
        this.quantity = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.finance.priceadjustment.PriceAdjustmentLevel")})
    @Column(name="level")
    public PriceAdjustmentLevel getLevel() {
        return this.level;
    }

    @ManyToOne
    @JoinColumn(name="fk_sales_item")
    public SalesItem getSalesItem() {
        return (SalesItem)this.salesItem.get();
    }

    @Transient
    public String getTargetUnit() {
        if (this.targetUnit == null) {
            this.targetUnit = this.getSalesItem() == null ? "-" : (InventoryItemPortion.getPortion("Whole").equals(this.getPortion()) ? (this.getSalesItem().isRefund() ? this.itemName + REFUND_STR : this.itemName) : (this.getSalesItem().isRefund() ? this.getSalesItem().getLabel() + REFUND_STR : this.getSalesItem().getLabel()));
        }
        return this.targetUnit;
    }

    @Transient
    public String getTarget() {
        if (this.target == null) {
            if (this.level.equals(PriceAdjustmentLevel.ACCOUNT_LEVEL)) {
                if (this.accountType != null) {
                    this.target = this.accountType.getLabel();
                }
            } else if (this.level.equals(PriceAdjustmentLevel.ITEM_LEVEL)) {
                this.target = this.getTargetUnit();
            } else {
                throw new IllegalStateException("AdjustmentLevel is neither and Account nor Item level.");
            }
        }
        return this.target;
    }

    @ManyToOne
    @JoinColumn(name="fk_inventory_portion")
    protected InventoryItemPortion getPortion() {
        return this.portion.get();
    }

    @Transient
    public String getSize() {
        return this.size;
    }

    public void setSize(String value) {
        this.size = value;
    }

    @Transient
    public Double getCost() {
        return this.savedTotal.abs().doubleValue();
    }

    @Transient
    public Long getNumber() {
        return this.number;
    }

    public void setNumber(Long value) {
        this.number = value;
    }

    @Transient
    public String getDiscountAmount() {
        if (this.getUnit().equals(PriceAdjustmentUnit.DOLLAR_UNIT)) {
            return Internationalization.getLiteralFor("DOLLAR_SIGN") + this.getAmount();
        }
        if (this.getUnit().equals(PriceAdjustmentUnit.PERCENTAGE_UNIT)) {
            return this.getAmount() + "%";
        }
        return "";
    }

    @ManyToOne
    @JoinColumn(name="fk_config_user")
    public User getUser() {
        return this.user.get();
    }

    @Transient
    public String getUserName() {
        return this.getUser().getName();
    }

    @Column(name="trading_day_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getTradingDayDate() {
        return this.tradingDayDate;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.sales.AccountType")})
    @Column(name="account_type")
    public AccountType getAccountType() {
        return this.accountType;
    }

    @Column(name="item_name")
    public String getItemName() {
        return this.itemName;
    }

    @Transient
    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    @Override
    public String toString() {
        StringBuilder SB = new StringBuilder(this.tradingDayDate + "");
        SB.append(": Name=");
        SB.append(this.getName());
        if (this.getLevel() != null) {
            SB.append(" Target=");
            SB.append(this.getTarget());
        }
        if (this.savedTotal != null) {
            SB.append(" Cost=");
            SB.append(this.getCost());
        }
        if (this.getUser() != null) {
            SB.append(" User=");
            SB.append(this.getUserName());
        }
        return SB.toString();
    }

    protected void setUser(User usr) {
        this.user.set(usr);
    }

    protected void setPortion(InventoryItemPortion newPortion) {
        this.portion.set(newPortion);
    }

    protected void setSalesItem(SalesLineItem item) {
        this.salesItem.set(item);
    }

    private void setSalesItem(SalesItem item) {
        this.salesItem.set(item);
    }

    protected void setAccountType(AccountType accType) {
        this.accountType = accType;
    }

    protected void setItemName(String iName) {
        this.itemName = iName;
    }

    protected void setTradingDayDate(Date date) {
        this.tradingDayDate = date;
    }

    protected void setCreationDate(Date date) {
        this.creationDate = date;
    }

    public void setSavedTotal(Price total) {
        this.savedTotal = total;
    }

    public void setAdjustmentType(PriceAdjustmentType paType) {
        this.adjustmentType = paType;
    }

    public void setName(String adjName) {
        this.name = adjName;
    }

    protected void setUnit(PriceAdjustmentUnit paUnit) {
        this.unit = paUnit;
    }

    protected void setAmount(Double amt) {
        this.amount = amt;
    }

    protected void setLevel(PriceAdjustmentLevel lvl) {
        this.level = lvl;
    }

    @Transient
    public String getType() {
        if (this.adjustmentType == null) {
            return null;
        }
        return this.adjustmentType.getLabel();
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<Date> CREATION_DATE;
        public PropertiedObject.Property<Price> SAVED_TOTAL;
        public PropertiedObject.Property<BigDecimal> QUANTITY;
        public PropertiedObject.Property<PriceAdjustmentType> ADJUSTMENT_TYPE;
        public PropertiedObject.Property<String> NAME;
        public PropertiedObject.Property<Double> AMOUNT;
        public PropertiedObject.Property<PriceAdjustmentUnit> UNIT;
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<PriceAdjustmentLevel> LEVEL;
        public PropertiedObject.Property<String> SOURCE;
        public PropertiedObject.Property<Date> TRADING_DAY_DATE;
        public PropertiedObject.Property<String> ITEM_NAME;
        public PropertiedObject.Property<AccountType> ACCOUNT_TYPE;
        public PropertiedObject.Property<InventoryItemUnit> INVENTORY_ITEM_UNIT_ID;
        public PropertiedObject.Property<InventoryItemPortion> PORTION;
        public PropertiedObject.Property<InventoryItemSize> SIZE;
        public PropertiedObject.Property<SalesLineItem> SALES_ITEM;
        public PersistentObject.DerivedProperty USER_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AdjustmentsReport.class), "userName");
        public PersistentObject.DerivedProperty VALUE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AdjustmentsReport.class), "value");
        public PersistentObject.DerivedProperty COST = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AdjustmentsReport.class), "cost");
        public PersistentObject.DerivedProperty TARGET = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AdjustmentsReport.class), "target");
        public PersistentObject.DerivedProperty TARGET_UNIT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AdjustmentsReport.class), "targetUnit");
        public PersistentObject.DerivedProperty TYPE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AdjustmentsReport.class), "type");
        public PersistentObject.DerivedProperty NUMBER = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AdjustmentsReport.class), "number");
        public PersistentObject.DerivedProperty DISCOUNT_AMOUNT = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AdjustmentsReport.class), "discountAmount");
    }
}

