/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.TradingDay;
import ordermate.database.reports.sales.general.itemsold.ItemSoldReport;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@AccessType(value="property")
public class CategorySalesReport
extends PersistentSummaryObject
implements Comparable {
    public static final Props Properties = new Props();
    private Price salesValue;
    private BigDecimal quantitySold = BigDecimal.valueOf(0L);
    private Double percOfSales = 0.0;
    private String inventoryCategoryName;
    private Reference<TradingDay> tradingDay;
    private Reference<DayPart> dayPart;

    public CategorySalesReport() {
        this.tradingDay = this.createReference(CategorySalesReport.Properties.TRADING_DAY);
        this.dayPart = this.createReference(CategorySalesReport.Properties.DAY_PART);
    }

    public CategorySalesReport(String theCategory) {
        this.tradingDay = this.createReference(CategorySalesReport.Properties.TRADING_DAY);
        this.dayPart = this.createReference(CategorySalesReport.Properties.DAY_PART);
        this.setInventoryCategoryName(theCategory);
        this.setSalesValue(Price.ZERO_NO_ROUND);
    }

    protected void setInventoryCategoryName(String name) {
        this.inventoryCategoryName = name;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    @Column(name="sales_value")
    public Price getSalesValue() {
        return this.salesValue;
    }

    protected void setSalesValue(Price newValue) {
        this.salesValue = newValue;
    }

    @Transient
    public BigDecimal getQuantitySold() {
        return this.quantitySold;
    }

    @Column(name="quantity_sold")
    protected double getQuantitySoldJPA() {
        return this.quantitySold.doubleValue();
    }

    protected void setQuantitySoldJPA(double value) {
        this.quantitySold = new BigDecimal(value);
    }

    @Transient
    public Double getPercOfSales() {
        return this.percOfSales;
    }

    @Transient
    public String getPercOfSalesStr() {
        return String.format("%.1f%%", this.percOfSales * 100.0);
    }

    public void setTotalSales(Price totalSales) {
        this.percOfSales = this.salesValue.doubleValue() / totalSales.doubleValue();
    }

    @ManyToOne
    @JoinColumn(name="fk_finance_trading_day")
    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    protected void setTradingDay(TradingDay value) {
        this.tradingDay.set(value);
    }

    @ManyToOne
    @JoinColumn(name="fk_config_day_part")
    public DayPart getDayPart() {
        return this.dayPart.get();
    }

    public void setDayPart(DayPart part) {
        this.dayPart.set(part);
    }

    @Column(name="category_name")
    public String getInventoryCategoryName() {
        return this.inventoryCategoryName;
    }

    public void addItemSoldReport(ItemSoldReport report) {
        this.salesValue = this.salesValue.add(report.getSalesValue());
        this.quantitySold = this.quantitySold.add(report.getQuantitySold());
    }

    public int compareTo(Object o) {
        String comparisonString = o instanceof CategorySalesReport ? ((CategorySalesReport)o).getInventoryCategoryName() : String.valueOf(o);
        return comparisonString.compareTo(this.getInventoryCategoryName());
    }

    @Transient
    public BigDecimal getSalesValueRaw() {
        return this.getSalesValue().toBigDecimal();
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<String> INVENTORY_CATEGORY_NAME;
        public PropertiedObject.Property<Price> SALES_VALUE;
        public PropertiedObject.Property<Double> QUANTITY_SOLD;
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<DayPart> DAY_PART;
        public PersistentObject.DerivedProperty PERC_OF_SALES = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CategorySalesReport.class), "percOfSales");
        public PersistentObject.DerivedProperty PERC_OF_SALES_STR = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CategorySalesReport.class), "percOfSalesStr");
        public PersistentObject.DerivedProperty SALES_VALUE_RAW = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CategorySalesReport.class), "salesValueRaw");
    }
}

