/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.database.misc.DayPart;
import ordermate.database.misc.TradingDay;
import ordermate.database.sales.AccountType;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@AccessType(value="property")
public class CoversReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Reference<TradingDay> tradingDay;
    private Integer covers;
    private Price totalSales;
    private AccountType accountType;
    private String sectionName;
    private Reference<DayPart> dayPart;

    public CoversReport() {
        this.tradingDay = this.createReference(CoversReport.Properties.TRADING_DAY);
        this.dayPart = this.createReference(CoversReport.Properties.DAY_PART);
    }

    @JoinColumn(name="fk_finance_trading_day")
    @ManyToOne(targetEntity=TradingDay.class)
    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    protected void setTradingDay(TradingDay value) {
        this.tradingDay.set(value);
    }

    @Transient
    public String getTradingDayString() {
        return TradingDay.fullDateFormatter.getFormat().format(this.getTradingDay().getDate());
    }

    @Transient
    public Date getTradingDayDate() {
        return this.getTradingDay() == null ? null : this.getTradingDay().getDate();
    }

    @Transient
    public String getDayOfWeek() {
        return DateTimeUtils.getDayOfWeekFormat().format(this.getTradingDay().getDate());
    }

    @Column(name="total_covers")
    public Integer getCovers() {
        return this.covers;
    }

    @Column(name="total_sales")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getTotalSales() {
        return this.totalSales;
    }

    @Transient
    public DayPart getDayPart() {
        return this.dayPart.get();
    }

    public void setDayPart(DayPart value) {
        this.dayPart.set(value);
    }

    @Transient
    public Price getDollarsPerHead() {
        if (this.totalSales == null || this.getCovers() == null || this.getCovers() == 0) {
            return Price.ZERO_DOLLAR;
        }
        return this.totalSales.divide(this.getCovers());
    }

    @Transient
    public String getWeekEnding() {
        return DateTimeUtils.formatDateForDisplay(this.getWeekEndingDate());
    }

    @Transient
    public String getMonth() {
        return new SimpleDateFormat("MMM yyyy").format(this.getTradingDayDate());
    }

    @Transient
    public Date getWeekEndingDate() {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.getTradingDayDate());
        while (cal.get(7) != 1) {
            cal.add(5, 1);
        }
        return cal.getTime();
    }

    @Override
    public String toString() {
        String name = this.getTradingDayDate() != null ? this.getTradingDay().getLabel() : "No Trading Day";
        return name + " Covers: " + this.getCovers() + "  Dollars per head:" + this.getDollarsPerHead();
    }

    @Column(name="section")
    public String getSectionName() {
        return this.sectionName;
    }

    protected void setCovers(Integer c) {
        this.covers = c;
    }

    protected void setSectionName(String name) {
        this.sectionName = name;
    }

    protected void setTotalSales(Price sales) {
        this.totalSales = sales;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.sales.AccountType")})
    @Column(name="account_type")
    public AccountType getAccountType() {
        return this.accountType;
    }

    protected void setAccountType(AccountType type) {
        this.accountType = type;
    }

    @Transient
    public String getDisplaySection() {
        if (AccountType.tableType.equals(this.accountType)) {
            return this.sectionName;
        }
        return this.accountType.getLabel();
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<String> SECTION_NAME;
        public PropertiedObject.Property<AccountType> ACCOUNT_TYPE;
        public PropertiedObject.Property<Integer> COVERS;
        public PropertiedObject.Property<Price> TOTAL_SALES;
        public PropertiedObject.Property<DayPart> DAY_PART;
        public PersistentObject.DerivedProperty<String> TRADING_DAY_STRING = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CoversReport.class), "tradingDayString");
        public PersistentObject.DerivedProperty<Date> TRADING_DAY_DATE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CoversReport.class), "tradingDayDate");
        public PersistentObject.DerivedProperty DAY_OF_WEEK = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CoversReport.class), "dayOfWeek");
        public PersistentObject.DerivedProperty WEEK_ENDING = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CoversReport.class), "weekEnding");
        public PersistentObject.DerivedProperty MONTH = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CoversReport.class), "month");
        public PersistentObject.DerivedProperty DOLLARS_PER_HEAD = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CoversReport.class), "dollarsPerHead");
        public PersistentObject.DerivedProperty DISPLAY_SECTION = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)CoversReport.class), "displaySection");
    }
}

