/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import ordermate.database.finance.debtors.group.DebtorGroup;

public class DebtorTransactionSummaryReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private String debtorName;
    private Reference<DebtorGroup> debtorGroup;
    private Price balance;
    private Price costTotal;
    private Price tax;
    private Price salesIncTax;
    private Price payments;

    public DebtorTransactionSummaryReport() {
        this.debtorGroup = this.createReference(DebtorTransactionSummaryReport.Properties.DEBTOR_GROUP);
        this.tax = Price.ZERO_NO_ROUND;
        this.salesIncTax = Price.ZERO_NO_ROUND;
    }

    public DebtorGroup getDebtorGroup() {
        return this.debtorGroup.get();
    }

    public void setDebtorGroup(DebtorGroup newGroup) {
        this.debtorGroup.set(newGroup);
    }

    public String getDebtorName() {
        return this.debtorName;
    }

    public void setDebtorName(String debtorName) {
        this.debtorName = debtorName;
    }

    public Price getBalance() {
        return this.balance;
    }

    public void setBalance(Price balance) {
        this.balance = balance;
    }

    public Price getCostTotal() {
        return this.costTotal;
    }

    public void setCostTotal(Price costTotal) {
        this.costTotal = costTotal;
    }

    public Price getSalesExTax() {
        return this.salesIncTax.subtract(this.tax);
    }

    public Price getTax() {
        return this.tax;
    }

    public void setTax(Price tax) {
        this.tax = tax;
    }

    public Price getSalesIncTax() {
        return this.salesIncTax;
    }

    public void setSalesIncTax(Price salesIncTax) {
        this.salesIncTax = salesIncTax;
    }

    public Price getPayments() {
        return this.payments;
    }

    public void setPayments(Price payments) {
        this.payments = payments;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        for (PropertiedObject.Property p : Properties) {
            Object o = PropertiedObject.PropsHelper.getPropertyValue(this, p);
            if (o == null) continue;
            sb.append(o.toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<DebtorGroup> DEBTOR_GROUP;
        public PropertiedObject.Property<String> DEBTOR_NAME;
        public PropertiedObject.Property BALANCE;
        public PropertiedObject.Property COST_TOTAL;
        public PersistentObject.DerivedProperty<Price> SALES_EX_TAX = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)DebtorTransactionSummaryReport.class), "salesExTax");
        public PropertiedObject.Property TAX;
        public PropertiedObject.Property SALES_INC_TAX;
        public PropertiedObject.Property PAYMENTS;
    }
}

