/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.FinanceUtils;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.Price;
import java.util.List;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.misc.SystemProperty;
import stockmate.database.interfaces.stock.MeasureUnitI;

public class ItemIngredients
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private String groupName;
    private String itemName;
    private String itemSize;
    private String itemPortion;
    private String usageMeasure;
    private Double usageQuantity;
    private Integer ingredientCount;
    private Price ingredientCost;
    private Price customCost;
    private Price minSalesPrice;
    private Reference<InventoryItemUnit> inventoryItemUnit;
    private MeasureUnit displayMeasureUnit;

    public ItemIngredients() {
        this.inventoryItemUnit = this.createReference(ItemIngredients.Properties.INVENTORY_ITEM_UNIT);
        this.displayMeasureUnit = null;
    }

    public static List getItemIngredientsReport() {
        return PersistenceManager.getObjectList(ItemIngredients.class, ItemIngredients.getRawSQL(null, null), new Object());
    }

    public static List getItemIngredientsReport(InventoryGroup group) {
        return PersistenceManager.getObjectList(ItemIngredients.class, ItemIngredients.getRawSQL(group, null), new Object[0]);
    }

    public static List getItemIngredientsReport(InventoryGroup group, InventoryProfile profile) {
        return PersistenceManager.getObjectList(ItemIngredients.class, ItemIngredients.getRawSQL(group, profile), new Object[0]);
    }

    public void setGroupName(String newGroupName) {
        this.groupName = newGroupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setItemName(String newItemName) {
        this.itemName = newItemName;
    }

    public String getItemName() {
        return this.itemName;
    }

    public void setItemSize(String newItemSize) {
        this.itemSize = newItemSize;
    }

    public String getItemSize() {
        return this.itemSize;
    }

    public void setItemPortion(String newItemPortion) {
        this.itemPortion = newItemPortion;
    }

    public String getItemPortion() {
        return this.itemPortion;
    }

    public String getDisplayStockUsage() {
        Quantity usageQty = new Quantity((MeasureUnitI)this.getUsageMeasure(), (double)this.getUsageQuantity());
        return usageQty.toString();
    }

    public void setIngredientCount(int newIngredientCount) {
        this.ingredientCount = newIngredientCount;
    }

    public int getIngredientCount() {
        return this.ingredientCount;
    }

    public Price getCost() {
        if (this.getCustomCost() != null) {
            return this.getCustomCost();
        }
        if (this.getIngredientCost() != null) {
            return this.getIngredientCost();
        }
        return new Price(0.0, 0.0);
    }

    public Price getCustomCost() {
        return this.customCost;
    }

    public Price getIngredientCost() {
        return this.ingredientCost;
    }

    public void setMinSalesPrice(Price newMinSalesPrice) {
        this.minSalesPrice = newMinSalesPrice;
    }

    public Price getMinSalesPrice() {
        return this.minSalesPrice;
    }

    protected List<TaxCode> getUnitTaxCodes() {
        return this.inventoryItemUnit.get().getTaxCodes();
    }

    public String getLinkedStockUsage() {
        if (this.getIngredientCount() == 0) {
            return "(empty)";
        }
        if (this.getIngredientCount() == 1) {
            return this.getDisplayStockUsage();
        }
        return "(" + this.getIngredientCount() + " items)";
    }

    protected void setInventoryItemUnit(InventoryItemUnit newInventoryItemUnit) {
        this.inventoryItemUnit.set(newInventoryItemUnit);
    }

    public InventoryItemUnit getInventoryItemUnit() {
        return this.inventoryItemUnit.get();
    }

    public void setUsageMeasure(String newUsageMeasure) {
        this.usageMeasure = newUsageMeasure;
    }

    public MeasureUnit getUsageMeasure() {
        if (this.displayMeasureUnit == null) {
            this.displayMeasureUnit = MeasureUnitHelper.getMeasureUnit(this.usageMeasure);
        }
        return this.displayMeasureUnit;
    }

    public void setUsageQuantity(Double newUsageQuantity) {
        this.usageQuantity = newUsageQuantity;
    }

    public Double getUsageQuantity() {
        return this.usageQuantity;
    }

    public boolean isItemProfitable() {
        double profitThreshold;
        Price taxAmount = Price.ZERO_NO_ROUND;
        for (TaxCode code : this.getUnitTaxCodes()) {
            taxAmount = taxAmount.add(code.getTaxAmount(this.getMinSalesPrice()));
        }
        double profitMargin = MathsUtils.roundDoubleToDecPlaces(FinanceUtils.calcGrossProfitMargin(this.getMinSalesPrice(), taxAmount, this.getCost()), 2);
        return profitMargin >= (profitThreshold = MathsUtils.roundDoubleToDecPlaces(SystemProperty.getInstance().getProfitMarginPerc(), 2));
    }

    private static String getRawSQL(InventoryGroup group, InventoryProfile profile) {
        StringBuilder inventoryGroupIDs = new StringBuilder();
        if (group != null) {
            inventoryGroupIDs.append("(").append(group.getID());
            for (InventoryGroup currentGroup : group.getRecursiveSubGroups()) {
                inventoryGroupIDs.append(",").append(currentGroup.getID().toString());
            }
            inventoryGroupIDs.append(") ");
        }
        String rawSQL = "SELECT inventory_item_unit.ID AS ID, inventory_item_unit.FK_system_tax_code AS FK_system_tax_code, inventory_group.Name AS group_name, inventory_item.Name AS item_name, inventory_size.Name AS size, inventory_portion.Name AS portion, stock_item.IngredientMeasureUnit AS measure_unit, stock_inventory_item_unit.Quantity AS ingredient_qty, SUM(stock_inventory_item_unit.Quantity * stock_item.CurrentCost / stock_item.Quantity * if(stock_item.tax_included, " + SystemProperty.getInstance().getBaseTaxFactor() + ",1)) / COUNT(DISTINCT inventory_unit_price_level_link.ID) AS ingredient_cost ,COUNT( DISTINCT stock_inventory_item_unit.ID) AS num_of_ingredients, inventory_item_unit.custom_stock_cost AS custom_cost , MIN(inventory_unit_price_level_link.Price) AS min_sales_price FROM inventory_item_unit INNER JOIN inventory_item \tON inventory_item_unit.FK_inventory_item = inventory_item.ID INNER JOIN inventory_group \tON inventory_item.FK_inventory_group = inventory_group.ID INNER JOIN inventory_size \tON inventory_item_unit.FK_inventory_size = inventory_size.ID INNER JOIN inventory_portion \tON inventory_item_unit.FK_inventory_portion = inventory_portion.ID INNER JOIN inventory_unit_price_level_link \tON inventory_item_unit.ID = inventory_unit_price_level_link.FK_inventory_item_unit LEFT JOIN stock_inventory_item_unit \tON stock_inventory_item_unit.FK_inventory_item_unit = inventory_item_unit.ID LEFT JOIN stock_item \tON stock_inventory_item_unit.FK_stock_item = stock_item.ID \t\tAND stock_item.system_state = 'ACTIVE' WHERE inventory_item_unit.system_state = 'ACTIVE' \tAND inventory_item.system_state = 'ACTIVE' \tAND inventory_group.system_state = 'ACTIVE' ";
        if (group != null) {
            rawSQL = rawSQL + " AND inventory_item.FK_inventory_group IN " + inventoryGroupIDs;
        }
        if (profile != null) {
            rawSQL = rawSQL + " AND inventory_group.FK_inventory_profile = " + profile.getID();
        }
        rawSQL = rawSQL + " GROUP BY inventory_item_unit.ID ";
        rawSQL = rawSQL + " ORDER BY inventory_group.Name ASC , inventory_item.Name ASC, ingredient_qty, portion, size ";
        return rawSQL;
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property GROUP_NAME;
        public PropertiedObject.Property ITEM_NAME;
        public PropertiedObject.Property ITEM_SIZE;
        public PropertiedObject.Property ITEM_PORTION;
        public PropertiedObject.Property USAGE_MEASURE;
        public PropertiedObject.Property USAGE_QUANTITY;
        public PropertiedObject.Property INGREDIENT_COUNT;
        public PropertiedObject.Property INGREDIENT_COST;
        public PropertiedObject.Property CUSTOM_COST;
        public PropertiedObject.Property MIN_SALES_PRICE;
        public PropertiedObject.Property<InventoryItemUnit> INVENTORY_ITEM_UNIT;

        @Override
        protected void initFieldLabels() {
            this.addFieldLabel(this.GROUP_NAME, "Group");
            this.addFieldLabel(this.ITEM_NAME, "Name");
            this.addFieldLabel(this.ITEM_SIZE, "Size");
            this.addFieldLabel(this.ITEM_PORTION, "Portion");
            this.addFieldLabel(this.USAGE_MEASURE, "Usage Measure");
            this.addFieldLabel(this.USAGE_QUANTITY, "Usage Quantity");
            this.addFieldLabel(this.INGREDIENT_COUNT, "Number of Ingredients");
            this.addFieldLabel(this.INGREDIENT_COST, "Cost (Ex Tax)");
        }
    }
}

