/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import ordermate.database.config.MeasureUnit;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.stock.usagelink.StockInventoryUsageLink;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;

public class ItemStockIngredientsReport
extends PersistentSummaryObject
implements Comparable<ItemStockIngredientsReport> {
    public static final Props Properties = new Props();
    private String salesName;
    private String stockName;
    private Integer quantity;
    private Reference<MeasureUnit> ingredientMeasureUnit;
    private Price customStockCost;
    private String portion;
    private String size;
    private String inventoryGroupName;
    private Reference<InventoryGroup> inventoryGroup;
    private Reference<StockInventoryUsageLink> stockInventoryUsageLink;

    public ItemStockIngredientsReport() {
        this.ingredientMeasureUnit = this.createReference(ItemStockIngredientsReport.Properties.INGREDIENT_MEASURE_UNIT);
        this.inventoryGroup = this.createReference(ItemStockIngredientsReport.Properties.INVENTORY_GROUP);
        this.stockInventoryUsageLink = this.createReference(ItemStockIngredientsReport.Properties.STOCK_INVENTORY_USAGE_LINK);
    }

    public String getSalesName() {
        return this.salesName;
    }

    public void setSalesName(String name) {
        this.salesName = name;
    }

    public String getStockName() {
        return this.stockName;
    }

    public void setStockName(String stock) {
        this.stockName = stock;
    }

    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer qty) {
        this.quantity = qty;
    }

    public String getIngredientMeasureUnit() {
        return this.ingredientMeasureUnit.get().getLabel();
    }

    public void setIngredientMeasureUnit(MeasureUnit measureUnit) {
        this.ingredientMeasureUnit.set(measureUnit);
    }

    public Price getCustomStockCost() {
        return this.customStockCost;
    }

    public void setCustomStockCost(Price cost) {
        this.customStockCost = cost;
    }

    public String getPortion() {
        return this.portion;
    }

    public void setPortion(String aPortion) {
        this.portion = aPortion;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String aSize) {
        this.size = aSize;
    }

    public String getInventoryGroupName() {
        return this.inventoryGroupName;
    }

    public void setInventoryGroupName(String groupName) {
        this.inventoryGroupName = groupName;
    }

    public void setInventoryGroup(InventoryGroup group) {
        this.inventoryGroup.set(group);
    }

    public InventoryGroup getInventoryGroup() {
        return this.inventoryGroup.get();
    }

    public void setStockInventoryUsageLink(StockInventoryUsageLink unit) {
        this.stockInventoryUsageLink.set(unit);
    }

    public StockInventoryUsageLink getStockInventoryUsageLink() {
        return this.stockInventoryUsageLink.get();
    }

    public String getReportName() {
        String name = this.getSalesName();
        if (StringUtils.isNotEmpty((String)this.getPortion()) || StringUtils.isNotEmpty((String)this.getSize())) {
            name = name + " (" + this.getSize() + ", " + this.getPortion() + ")";
        }
        return name;
    }

    public String getReportQty() {
        if (this.getQuantity() == null) {
            return "";
        }
        return this.getQuantity() + " " + this.getIngredientMeasureUnit();
    }

    public Price getCost() {
        StockInventoryUsageLink link = this.getStockInventoryUsageLink();
        if (link == null) {
            return this.getCustomStockCost();
        }
        return new Price(link.calculateStockItemLinkCost(null, true, false), 0.0);
    }

    public String getInventoryGroupFull() {
        return this.getInventoryGroup().getLabelFull();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof ItemStockIngredientsReport)) {
            return false;
        }
        ItemStockIngredientsReport o = (ItemStockIngredientsReport)other;
        return new EqualsBuilder().appendSuper(super.equals(other)).append((Object)this.getInventoryGroup().getLabelFull().toLowerCase(), (Object)o.getInventoryGroup().getLabelFull().toLowerCase()).append((Object)this.getReportName().toLowerCase(), (Object)o.getReportName().toLowerCase()).append((Object)this.getStockName().toLowerCase(), (Object)o.getStockName().toLowerCase()).isEquals();
    }

    @Override
    public int compareTo(ItemStockIngredientsReport o) {
        return new CompareToBuilder().append((Object)this.getInventoryGroup().getLabelFull(), (Object)o.getInventoryGroup().getLabelFull(), String.CASE_INSENSITIVE_ORDER).append((Object)this.getReportName(), (Object)o.getReportName(), String.CASE_INSENSITIVE_ORDER).append((Object)this.getStockName(), (Object)o.getStockName(), String.CASE_INSENSITIVE_ORDER).toComparison();
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property INVENTORY_GROUP_NAME;
        public PropertiedObject.Property SALES_NAME;
        public PropertiedObject.Property SIZE;
        public PropertiedObject.Property PORTION;
        public PropertiedObject.Property STOCK_NAME;
        public PropertiedObject.Property CUSTOM_STOCK_COST;
        public PropertiedObject.Property QUANTITY;
        public PropertiedObject.Property<MeasureUnit> INGREDIENT_MEASURE_UNIT;
        public PropertiedObject.Property<InventoryGroup> INVENTORY_GROUP;
        public PropertiedObject.Property<StockInventoryUsageLink> STOCK_INVENTORY_USAGE_LINK;
        public PersistentObject.DerivedProperty<String> REPORT_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemStockIngredientsReport.class), "reportName");
        public PersistentObject.DerivedProperty<String> REPORT_QTY = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemStockIngredientsReport.class), "reportQty");
        public PersistentObject.DerivedProperty<Price> COST = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemStockIngredientsReport.class), "cost");
        public PersistentObject.DerivedProperty<String> INVENTORY_GROUP_FULL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ItemStockIngredientsReport.class), "inventoryGroupFull");
    }
}

