/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.Price;

public class RefundReportSummary
implements PropertiedObject {
    public static final Props Properties = new Props();
    private String user;
    private Price totalRefunded;
    private Integer totalQty;
    private int numOfRefunds;

    public RefundReportSummary(String userName) {
        this.user = userName;
        this.totalRefunded = new Price(0.0, 0.01);
        this.totalQty = 0;
        this.numOfRefunds = 0;
    }

    public void addRefund(int qty, Price total) {
        this.totalRefunded = this.totalRefunded.add(total);
        this.totalQty = this.totalQty + qty;
        ++this.numOfRefunds;
    }

    public final String getUser() {
        return this.user;
    }

    public final Price getTotalRefunded() {
        return this.totalRefunded;
    }

    public final String getAvgRefunded() {
        if (this.numOfRefunds == 0) {
            return null;
        }
        Price averageRefunded = this.totalRefunded.divide(this.numOfRefunds);
        return averageRefunded.toString();
    }

    public final Integer getTotalQty() {
        return this.totalQty;
    }

    @Override
    public Props getProperties() {
        return Properties;
    }

    @Override
    public <T> T getPropertyValue(PropertiedObject.Property<T> prop) {
        return PropertiedObject.PropsHelper.getPropertyValue(this, prop);
    }

    public static class Props
    extends PropertiedObject.Props {
        public PropertiedObject.Property<String> USER;
        public PropertiedObject.Property<Price> TOTAL_REFUNDED;
        public PropertiedObject.Property<Integer> TOTAL_QTY;
        public PersistentObject.DerivedProperty<String> AVG_REFUNDED = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)RefundReportSummary.class), "avgRefunded");
    }
}

