/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports;

import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.Price;
import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.users.User;

@Entity
public class RefundsReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Reference<User> user;
    private String portion;
    private Reference<SalesLineItem> salesItem;
    private String itemName;
    private String itemSize;
    private Date creationTime;
    private BigDecimal quantity;
    private Price unitPrice;

    public RefundsReport() {
        this.user = this.createReference(RefundsReport.Properties.USER);
        this.salesItem = this.createReference(RefundsReport.Properties.SALES_ITEM);
    }

    @Column(name="creation_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreationTime() {
        return this.creationTime;
    }

    @Transient
    public String getUserName() {
        return this.getUser().getName();
    }

    @Transient
    public Price getTotal() {
        return this.unitPrice.multiply(-this.quantity.doubleValue());
    }

    @Column(name="quantity")
    public BigDecimal getQuantity() {
        return new BigDecimal(-this.quantity.doubleValue());
    }

    @ManyToOne
    @JoinColumn(name="fk_sales_item")
    public SalesItem getSalesItem() {
        return (SalesItem)this.salesItem.get();
    }

    @Column(name="portion_label")
    public String getPortion() {
        return this.portion;
    }

    @ManyToOne
    @JoinColumn(name="fk_config_user")
    public User getUser() {
        return this.user.get();
    }

    @Column(name="item_name")
    public String getItemName() {
        return this.salesItem.get().getLabel();
    }

    @Column(name="unit_price")
    public Price getUnitPrice() {
        return this.unitPrice;
    }

    protected void setCreationTime(Date value) {
        this.creationTime = value;
    }

    protected void setQuantity(BigDecimal value) {
        this.quantity = value;
    }

    protected void setSalesItem(SalesItem value) {
        this.salesItem.set(value);
    }

    protected void setPortion(String value) {
        this.portion = value;
    }

    protected void setUser(User value) {
        this.user.set(value);
    }

    protected void setItemName(String value) {
        this.itemName = value;
    }

    protected void setUnitPrice(Price value) {
        this.unitPrice = value;
    }

    @Column(name="size_label")
    public String getItemSize() {
        return this.itemSize;
    }

    public void setItemSize(String itemSize) {
        this.itemSize = itemSize;
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property CREATION_TIME;
        public PropertiedObject.Property<SalesQuantity> QUANTITY;
        public PropertiedObject.Property PORTION;
        public PropertiedObject.Property UNIT_PRICE;
        public PropertiedObject.Property SALES_ITEM;
        public PropertiedObject.Property USER;
        public PersistentObject.DerivedProperty<String> USER_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)RefundsReport.class), "userName");
        public PersistentObject.DerivedProperty<Price> TOTAL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)RefundsReport.class), "total");
        public PersistentObject.DerivedProperty<String> ITEM_NAME = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)RefundsReport.class), "itemName");
        public PropertiedObject.Property ITEM_SIZE;
    }
}

