/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports;

import au.com.ordermate.oquery.search.filter.IRangedQuerySearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.ObjectJoinSearchFilter;
import au.com.ordermate.oquery.search.filter.implementation.RangeJoinSearchFilter;
import au.com.ordermate.persistence.PersistentEnumeration;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.IRangedSearchFilter;
import au.com.ordermate.search.ISingleValueSearchFilter;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.StringUtils;
import java.text.DateFormat;
import java.text.Format;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.Table;
import ordermate.database.sales.Account;
import ordermate.database.sales.SalesItemQuantity;

public class ReportProviderHelper {
    private static String ACCOUNT_READABLE_NAME = "Account";
    private static String SALESITEMQUANTITY_READABLE_NAME = "Item";
    private String newline = "\\n";
    private String subTitleSuffix = ": ";

    public DateFormat getDateFormat() {
        return DateTimeUtils.getDateMonthYearFormat();
    }

    public DateFormat getTimeFormat() {
        return DateFormat.getTimeInstance();
    }

    public void setNewline(String value) {
        this.newline = value;
    }

    public void setSubTitleSuffix(String value) {
        this.subTitleSuffix = value;
    }

    public void appendDatedSubtitle(StringBuilder SB, IRangedSearchFilter<Date> dateRangeFilter, IRangedSearchFilter<?> timeFilter) {
        if (dateRangeFilter.hasSearchValue()) {
            DateFormat dateFormat = this.getDateFormat();
            SB.append(dateFormat.format(dateRangeFilter.getStart()));
            SB.append(" to ").append(dateFormat.format(dateRangeFilter.getEnd()));
        }
        if (timeFilter != null && timeFilter.hasSearchValue()) {
            DateFormat timeFormat = this.getTimeFormat();
            Object timeStart = timeFilter.getStart();
            Object timeEnd = timeFilter.getEnd();
            if (timeStart instanceof Calendar) {
                timeStart = ((Calendar)timeStart).getTime();
                timeEnd = ((Calendar)timeEnd).getTime();
            }
            SB.append(" between ").append(timeFormat.format(timeStart)).append(" and ").append(timeFormat.format(timeEnd));
        }
    }

    private void appendSubTitle(StringBuilder SB, String name) {
        if (SB.length() != 0) {
            SB.append(this.newline);
        }
        SB.append(name);
        if (this.subTitleSuffix != null) {
            SB.append(this.subTitleSuffix);
        }
    }

    public void appendSubTitleAndValue(StringBuilder SB, String name, String value) {
        if (!StringUtils.isEmpty(value)) {
            this.appendSubTitle(SB, name);
            SB.append(value);
        }
    }

    public void appendSearchFilter(StringBuilder SB, String name, ISingleValueSearchFilter<?> filter) {
        if (filter.hasSearchValue()) {
            Object searchValue = filter.getSearchValue();
            if (searchValue instanceof Collection) {
                this.appendCollection(SB, name, (Collection)searchValue);
            } else {
                this.appendSubTitle(SB, name);
                if (searchValue instanceof Date) {
                    SB.append(this.getDateFormat().format(searchValue));
                } else {
                    SB.append(String.valueOf(searchValue));
                }
            }
        }
    }

    public void appendRangeSearchFilter(StringBuilder SB, String name, IRangedSearchFilter filter, Format format) {
        if (filter.hasSearchValue()) {
            Object searchStart = filter.getStart();
            Object searchEnd = filter.getEnd();
            this.appendSubTitle(SB, name);
            if (format != null) {
                SB.append(format.format(searchStart)).append(" to ").append(format.format(searchEnd));
            } else {
                SB.append(String.valueOf(searchStart)).append(" to ").append(String.valueOf(searchEnd));
            }
        }
    }

    public void appendCollection(StringBuilder SB, String name, Collection<Object> things) {
        if (things != null && things.size() > 0) {
            this.appendSubTitle(SB, name);
            for (Object option : things) {
                if (option instanceof PersistentEnumeration) {
                    SB.append(String.valueOf(((PersistentEnumeration)option).getLabel()));
                } else {
                    SB.append(String.valueOf(option));
                }
                SB.append(", ");
            }
            SB.replace(SB.length() - 2, SB.length(), "");
        }
    }

    public static String describeRangeFilter(IRangedQuerySearchFilter<?> filter) {
        Class subjectClass = filter.getProperty().getOwner();
        if (filter instanceof RangeJoinSearchFilter) {
            RangeJoinSearchFilter joinFilter = (RangeJoinSearchFilter)filter;
            List<PropertiedObject.Property> joinProperties = joinFilter.getListOfPropertyJoinPath();
            Class searchResult = ReportProviderHelper.findPropertyInJoinList(joinProperties, new Class[]{Account.class, SalesItemQuantity.class});
            if (searchResult != null) {
                subjectClass = searchResult;
            }
        }
        String className = subjectClass.getSimpleName();
        if (SalesItemQuantity.class.getSimpleName().equals(className)) {
            className = SALESITEMQUANTITY_READABLE_NAME;
        }
        return ReportProviderHelper.spacifyClassName(className) + " creation time";
    }

    public static String describeSingleValueFilter(ISingleValueSearchFilter<?> filter) {
        Class subjectClass = filter.getProperty().getOwner();
        if (filter instanceof ObjectJoinSearchFilter) {
            ObjectJoinSearchFilter joinFilter = (ObjectJoinSearchFilter)filter;
            List<PropertiedObject.Property> joinProperties = joinFilter.getListOfPropertyJoinPath();
            Class searchResult = ReportProviderHelper.findPropertyInJoinList(joinProperties, new Class[]{Account.class, SalesItemQuantity.class});
            if (searchResult != null) {
                subjectClass = searchResult;
            }
        }
        String className = subjectClass.getSimpleName();
        if (SalesItemQuantity.class.getSimpleName().equals(className)) {
            className = SALESITEMQUANTITY_READABLE_NAME;
        }
        return ReportProviderHelper.spacifyClassName(className) + " creation time";
    }

    protected static Class findPropertyInJoinList(List<PropertiedObject.Property> properties, Class[] owners) {
        if (properties.size() == 1) {
            return properties.get(0).getOwner();
        }
        for (PropertiedObject.Property property : properties) {
            String name = property.getOwner().getSimpleName();
            for (Class ownerClass : owners) {
                if (!ownerClass.getSimpleName().equals(name)) continue;
                return property.getOwner();
            }
        }
        return null;
    }

    public static String describeQueryLink(String queryString) {
        String className = "";
        Table accountTable = Account.class.getAnnotation(Table.class);
        Table salesItemQuantityTable = SalesItemQuantity.class.getAnnotation(Table.class);
        if (accountTable != null && queryString.indexOf(accountTable.name()) != -1) {
            className = ACCOUNT_READABLE_NAME;
        } else if (salesItemQuantityTable != null && queryString.indexOf(salesItemQuantityTable.name()) != -1) {
            className = SALESITEMQUANTITY_READABLE_NAME;
        }
        return className;
    }

    public static String spacifyClassName(String className) {
        String workingString = className;
        while (workingString.matches(".*(\\S)([A-Z]).*")) {
            workingString = workingString.replaceAll("(\\S)([A-Z])", "$1 $2");
        }
        return workingString;
    }
}

