/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports;

import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import java.util.Date;
import ordermate.database.config.location.SalesLocation;

public class SalesByCategoryReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Date date;
    private String category;
    private String dayPartLabel;
    private Price total;
    private Reference<SalesLocation> location;

    public SalesByCategoryReport() {
        this.location = this.createReference(SalesByCategoryReport.Properties.LOCATION);
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public Price getTotal() {
        return this.total;
    }

    public void setTotal(Price total) {
        this.total = total;
    }

    public String getDayPartLabel() {
        return this.dayPartLabel;
    }

    public void setDayPartLabel(String dayPartLabel) {
        this.dayPartLabel = dayPartLabel;
    }

    public SalesLocation getLocation() {
        return this.location.get();
    }

    public void setLocation(SalesLocation loc) {
        this.location.set(loc);
    }

    public void addReport(SalesByCategoryReport report) {
        if (this.total == null) {
            this.total = new Price(0.0, 0.0);
        }
        this.total = this.total.add(report.getTotal());
    }

    @Override
    public String toString() {
        return this.getDayPartLabel() + " " + this.getCategory() + " " + this.getTotal() + " for " + this.getDate();
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<Date> DATE;
        public PropertiedObject.Property<String> CATEGORY;
        public PropertiedObject.Property<String> DAY_PART_LABEL;
        public PropertiedObject.Property<Price> TOTAL;
        public PropertiedObject.Property<SalesLocation> LOCATION;
    }
}

