/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.reports;

import au.com.ordermate.persistence.PersistentSummaryObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.util.Price;
import java.util.Date;
import ordermate.database.users.User;

public class StaffCostReport
extends PersistentSummaryObject {
    public static final Props Properties = new Props();
    private Date rangeIn;
    private Date rangeOut;
    private Price payRate;
    private Reference<User> user;

    public StaffCostReport() {
        this.user = this.createReference(StaffCostReport.Properties.USER);
    }

    public User getUser() {
        return this.user.get();
    }

    protected void setUser(User newUser) {
        this.user.set(newUser);
    }

    public Date getRangeIn() {
        return this.rangeIn;
    }

    public Date getRangeOut() {
        return this.rangeOut;
    }

    public Price getPayRate() {
        return this.payRate;
    }

    public void setPayRate(Price price) {
        this.payRate = price;
    }

    public Price getLabourCost() {
        return this.getPayRate().multiply(this.getLabourHours());
    }

    public double getLabourHours() {
        long durationSecs = (this.rangeOut.getTime() - this.rangeIn.getTime()) / 1000L;
        return (double)durationSecs / 60.0 / 60.0;
    }

    public static class Props
    extends PersistentSummaryObject.Props {
        public PropertiedObject.Property<Date> RANGE_IN;
        public PropertiedObject.Property<Date> RANGE_OUT;
        public PropertiedObject.Property<Price> PAY_RATE;
        public PropertiedObject.Property<User> USER;
    }
}

